/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hikari.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.zaxxer.hikari.pool.HikariPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HikariDataSourceAggregator
extends AbstractAggregator {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private static final String[] EMPTY_SIGNATURE = new String[0];
    private static final String HIKARI_DATA_SOURCE_OBJECT_NAME = "com.zaxxer.hikari:type=HikariDataSource,*";
    private Map<String, Map<String, Object>> poolParams = new HashMap<String, Map<String, Object>>();

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> res = new ArrayList<MonitorDataRow>();
        try {
            Set<String> urls = this.poolParams.keySet();
            Iterator<String> iterator = urls.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> params = this.poolParams.get(iterator.next());
                MonitorDataRow row = new MonitorDataRow();
                row.add("url", params.get("url"));
                row.add("driverName", params.get("driverName"));
                row.add("totalConnections", params.get("totalConnections"));
                row.add("maximumPoolSize", params.get("maximumPoolSize"));
                row.add("activeConnections", params.get("activeConnections"));
                row.add("idleConnections", params.get("idleConnections"));
                row.add("threadsAwaitingConnection", params.get("threadsAwaitingConnection"));
                res.add(row);
            }
            this.poolParams.clear();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "hikari harvest: \u91c7\u96c6\u76d1\u63a7\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return res;
    }

    public String getName() {
        return "dataSource";
    }

    public void onstart(HikariPool pool) {
        String jdbcUrl;
        if (pool != null && !this.poolParams.containsKey(jdbcUrl = pool.config.getJdbcUrl())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("url", jdbcUrl);
            map.put("driverName", pool.config.getDriverClassName());
            map.put("maximumPoolSize", pool.config.getMaximumPoolSize());
            map.put("totalConnections", pool.getTotalConnections());
            map.put("activeConnections", pool.getActiveConnections());
            map.put("idleConnections", pool.getIdleConnections());
            map.put("threadsAwaitingConnection", pool.getThreadsAwaitingConnection());
            this.poolParams.put(jdbcUrl, map);
        }
    }
}

