/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.collector;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultServerNodeStats;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.mongodb.stats.MongoNodeStats;
import com.mongodb.connection.ServerType;
import java.util.Map;

public class MongoNodeAggregator
extends SinglePrimaryKeyAggregator<MongoNodeStats> {
    public static final String SERVER_ADDRESS = "serverAddr";
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<MongoNodeStats> statsLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onStart(String serverAddr, ServerType serverType) {
        if (!this.isEnable) {
            return;
        }
        MongoNodeStats stats = (MongoNodeStats)this.getValue(serverAddr);
        stats.setType(serverType);
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        MongoNodeStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
        }
    }

    public void onFinally() {
        Long timeUsed;
        if (!this.isEnable) {
            return;
        }
        DefaultServerNodeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally((timeUsed = Long.valueOf(System.nanoTime() - startTime)).longValue())) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.set(null);
        this.startTimeLocal.set(null);
    }

    protected Class<MongoNodeStats> getValueType() {
        return MongoNodeStats.class;
    }

    public String getName() {
        return "serverNode";
    }

    protected String primaryKey() {
        return SERVER_ADDRESS;
    }
}

