/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqClientIdConsumeAggregator;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqClientIdPullAggregator;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqConsumeListenerAggregator;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqConsumeServicePoolAggregator;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqQueueConsumeAggregator;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqQueuePullAggregator;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqTopicConsumeAggregator;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqTopicPullAggregator;
import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.common.message.MessageQueue;

public class RocketMqConsumerCollector
extends Collector {
    public static final RocketMqConsumerCollector INSTANCE = new RocketMqConsumerCollector();
    public static final RocketMqConsumeListenerAggregator CONSUME_LISTENER_AGGREGATOR = new RocketMqConsumeListenerAggregator();
    public static final RocketMqConsumeServicePoolAggregator CONSUME_SERVICE_POOL_AGGREGATOR = new RocketMqConsumeServicePoolAggregator();
    public static final RocketMqClientIdConsumeAggregator CLIENT_ID_CONSUME_AGGREGATOR = new RocketMqClientIdConsumeAggregator();
    public static final RocketMqTopicConsumeAggregator TOPIC_CONSUME_AGGREGATOR = new RocketMqTopicConsumeAggregator();
    public static final RocketMqQueueConsumeAggregator QUEUE_CONSUME_AGGREGATOR = new RocketMqQueueConsumeAggregator();
    public static final RocketMqClientIdPullAggregator CLIENT_ID_PULL_AGGREGATOR = new RocketMqClientIdPullAggregator();
    public static final RocketMqTopicPullAggregator TOPIC_PULL_AGGREGATOR = new RocketMqTopicPullAggregator();
    public static final RocketMqQueuePullAggregator QUEUE_PULL_AGGREGATOR = new RocketMqQueuePullAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();

    public static void onPushConsumeStart(String consumeListenerId, String clientId, String group, MessageQueue mq) {
        CONSUME_LISTENER_AGGREGATOR.onStart(consumeListenerId);
        CLIENT_ID_CONSUME_AGGREGATOR.onStart(clientId, group);
        TOPIC_CONSUME_AGGREGATOR.onStart(clientId, group, mq.getTopic());
        QUEUE_CONSUME_AGGREGATOR.onStart(clientId, group, RocketMqUtils.constructQueueFromMq(mq));
    }

    public static void onPushConsumeFinally(int msgCount, int msgBytes, int reconsumeTimes, boolean hasError) {
        if (!hasError) {
            CONSUME_LISTENER_AGGREGATOR.incrementConsumedMsgCount(msgCount);
            CONSUME_LISTENER_AGGREGATOR.incrementConsumedBytesCount(msgBytes);
            CONSUME_LISTENER_AGGREGATOR.incrementReconsumeTimes(reconsumeTimes);
            CLIENT_ID_CONSUME_AGGREGATOR.incrementConsumedMsgCount(msgCount);
            CLIENT_ID_CONSUME_AGGREGATOR.incrementConsumedBytesCount(msgBytes);
            CLIENT_ID_CONSUME_AGGREGATOR.incrementReconsumeTimes(reconsumeTimes);
            TOPIC_CONSUME_AGGREGATOR.incrementConsumedMsgCount(msgCount);
            TOPIC_CONSUME_AGGREGATOR.incrementConsumedBytesCount(msgBytes);
            TOPIC_CONSUME_AGGREGATOR.incrementReconsumeTimes(reconsumeTimes);
            QUEUE_CONSUME_AGGREGATOR.incrementConsumedMsgCount(msgCount);
            QUEUE_CONSUME_AGGREGATOR.incrementConsumedBytesCount(msgBytes);
            QUEUE_CONSUME_AGGREGATOR.incrementReconsumeTimes(reconsumeTimes);
        }
        CONSUME_LISTENER_AGGREGATOR.onFinally();
        CLIENT_ID_CONSUME_AGGREGATOR.onFinally();
        TOPIC_CONSUME_AGGREGATOR.onFinally();
        QUEUE_CONSUME_AGGREGATOR.onFinally();
    }

    public static void onPushConsumeError(String errorTraceId) {
        CONSUME_LISTENER_AGGREGATOR.onError(errorTraceId);
        CLIENT_ID_CONSUME_AGGREGATOR.onError(errorTraceId);
        TOPIC_CONSUME_AGGREGATOR.onError(errorTraceId);
        QUEUE_CONSUME_AGGREGATOR.onError(errorTraceId);
    }

    public static void onPullStart(String clientId, String group, MessageQueue mq) {
        CLIENT_ID_PULL_AGGREGATOR.onStart(clientId, group);
        TOPIC_PULL_AGGREGATOR.onStart(clientId, group, mq.getTopic());
        QUEUE_PULL_AGGREGATOR.onStart(clientId, group, RocketMqUtils.constructQueueFromMq(mq));
    }

    public static Map<String, Object> onPullStartAsync(String clientId, String group, MessageQueue mq) {
        Map<String, Object> clientIdRecord = CLIENT_ID_PULL_AGGREGATOR.onStartAsync(clientId, group);
        Map<String, Object> topicRecord = TOPIC_PULL_AGGREGATOR.onStartAsync(clientId, group, mq.getTopic());
        Map<String, Object> queueRecord = QUEUE_PULL_AGGREGATOR.onStartAsync(clientId, group, RocketMqUtils.constructQueueFromMq(mq));
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("clientIdRecord", clientIdRecord);
        res.put("topicRecord", topicRecord);
        res.put("queueRecord", queueRecord);
        return res;
    }

    public static void onPullFinally(int msgCount, int msgBytes, boolean isFoundFailed) {
        if (!isFoundFailed) {
            CLIENT_ID_PULL_AGGREGATOR.incrementPulledMsgCount(msgCount);
            CLIENT_ID_PULL_AGGREGATOR.incrementPulledMsgBytes(msgBytes);
            TOPIC_PULL_AGGREGATOR.incrementPulledMsgCount(msgCount);
            TOPIC_PULL_AGGREGATOR.incrementPulledMsgBytes(msgBytes);
            QUEUE_PULL_AGGREGATOR.incrementPulledMsgCount(msgCount);
            QUEUE_PULL_AGGREGATOR.incrementPulledMsgBytes(msgBytes);
        }
        CLIENT_ID_PULL_AGGREGATOR.onFinally();
        TOPIC_PULL_AGGREGATOR.onFinally();
        QUEUE_PULL_AGGREGATOR.onFinally();
    }

    public static void onPullFinallyAsync(Map<String, Object> context, int msgCount, int msgBytes, boolean isFoundFailed) {
        Map records = (Map)context.get("records");
        Map clientIdRecord = (Map)records.get("clientIdRecord");
        Map topicRecord = (Map)records.get("topicRecord");
        Map queueRecord = (Map)records.get("queueRecord");
        SpanEvent spanEvent = (SpanEvent)context.get("spanEvent");
        String nameserver = (String)context.get("nameServer");
        if (spanEvent != null) {
            clientIdRecord.put("spanEvent", spanEvent);
            topicRecord.put("spanEvent", spanEvent);
            queueRecord.put("spanEvent", spanEvent);
        }
        if (nameserver != null) {
            clientIdRecord.put("nameServer", nameserver);
            topicRecord.put("nameServer", nameserver);
            queueRecord.put("nameServer", nameserver);
        }
        if (!isFoundFailed) {
            CLIENT_ID_PULL_AGGREGATOR.incrementPulledMsgCountAsync(clientIdRecord, msgCount);
            CLIENT_ID_PULL_AGGREGATOR.incrementPulledMsgBytesAsync(clientIdRecord, msgBytes);
            TOPIC_PULL_AGGREGATOR.incrementPulledMsgCountAsync(topicRecord, msgCount);
            TOPIC_PULL_AGGREGATOR.incrementPulledMsgBytesAsync(topicRecord, msgBytes);
            QUEUE_PULL_AGGREGATOR.incrementPulledMsgCountAsync(queueRecord, msgCount);
            QUEUE_PULL_AGGREGATOR.incrementPulledMsgBytesAsync(queueRecord, msgBytes);
        }
        CLIENT_ID_PULL_AGGREGATOR.onFinallyAsync(clientIdRecord);
        TOPIC_PULL_AGGREGATOR.onFinallyAsync(topicRecord);
        QUEUE_PULL_AGGREGATOR.onFinallyAsync(queueRecord);
    }

    public static void onPullError(String errorTraceId) {
        CLIENT_ID_PULL_AGGREGATOR.onError(errorTraceId);
        TOPIC_PULL_AGGREGATOR.onError(errorTraceId);
        QUEUE_PULL_AGGREGATOR.onError(errorTraceId);
    }

    public static void onPullErrorAsync(Map<String, Object> context, String errorTraceId) {
        Map records = (Map)context.get("records");
        Map clientIdRecord = (Map)records.get("clientIdRecord");
        Map topicRecord = (Map)records.get("topicRecord");
        Map queueRecord = (Map)records.get("queueRecord");
        CLIENT_ID_PULL_AGGREGATOR.onErrorAsync(clientIdRecord, errorTraceId);
        TOPIC_PULL_AGGREGATOR.onErrorAsync(topicRecord, errorTraceId);
        QUEUE_PULL_AGGREGATOR.onErrorAsync(queueRecord, errorTraceId);
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "RocketMqConsumer";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)CONSUME_LISTENER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CONSUME_SERVICE_POOL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CLIENT_ID_CONSUME_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)TOPIC_CONSUME_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)QUEUE_CONSUME_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CLIENT_ID_PULL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)TOPIC_PULL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)QUEUE_PULL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

