/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rocketmq.RocketMqContext;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqConsumerCollector;
import java.util.Map;
import org.apache.rocketmq.common.message.MessageQueue;

public class AsyncPullCallbackConInterceptor
implements Interceptor {
    private static final String PUSH_CONSUMER_CLASS_NAME = "org/apache/rocketmq/client/impl/consumer/DefaultMQPushConsumerImpl";
    private static final String PULL_MESSAGE_METHOD_NAME = "pullMessage";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RocketMqConsumerCollector.INSTANCE.isEnable()) {
                Map<String, Object> context = RocketMqContext.getContext();
                String clientId = (String)context.get("clientId");
                String group = (String)context.get("group");
                MessageQueue mq = (MessageQueue)context.get("messageQueue");
                SpanEvent spanEvent = TraceCollector.onStart((String)PUSH_CONSUMER_CLASS_NAME, (String)PULL_MESSAGE_METHOD_NAME, (String)"RocketMqConsumer");
                if (spanEvent != null) {
                    spanEvent.addTag("topic", mq.getTopic());
                    spanEvent.addTag("brokerName", mq.getBrokerName());
                    spanEvent.addTag("queueId", String.valueOf(mq.getQueueId()));
                    context.put("spanEvent", spanEvent);
                    TraceCollector.onFinally((boolean)false);
                }
                Map<String, Object> records = RocketMqConsumerCollector.onPullStartAsync(clientId, group, mq);
                context.put("records", records);
                TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"context", context);
            }
        }
        catch (Exception pullMessageException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)pullMessageException);
        }
    }
}

