/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.rocketmq.RocketMqContext;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqConsumerCollector;
import java.util.Map;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPullConsumerImpl;
import org.apache.rocketmq.common.message.MessageQueue;

public class PullConsumerAsyncPullInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (RocketMqConsumerCollector.INSTANCE.isEnable()) {
                DefaultMQPullConsumerImpl consumerImpl = (DefaultMQPullConsumerImpl)object;
                DefaultMQPullConsumer consumer = (DefaultMQPullConsumer)((AttributeAccess)consumerImpl).getLopsFileds()[0];
                String clientId = RocketMqUtils.getClientId(consumerImpl);
                String group = consumer.getConsumerGroup();
                String nameserver = consumer.getNamesrvAddr();
                MessageQueue mq = (MessageQueue)args[0];
                Map<String, Object> context = RocketMqContext.getContext();
                context.put("clientId", clientId);
                context.put("group", group);
                context.put("messageQueue", mq);
                context.put("nameServer", nameserver);
            }
        }
        catch (Exception rocketMqPullException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPullException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RocketMqConsumerCollector.INSTANCE.isEnable()) {
                RocketMqConsumerCollector.onException(e);
            }
        }
        catch (Exception rocketMqPullException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPullException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            RocketMqContext.CONTEXT_LOCAL.remove();
        }
        catch (Exception rocketMqPullException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPullException);
        }
    }
}

