/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.clickhouse;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.clickhouse.collector.ClickHouseCollector;
import java.sql.SQLException;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseStatementImpl;
import ru.yandex.clickhouse.Writer;
import ru.yandex.clickhouse.domain.ClickHouseFormat;

public final class ClickHouseUtils {
    public static Integer getConnectionId(ClickHouseStatementImpl statement) throws SQLException {
        ClickHouseConnection connection = statement.getConnection();
        if (connection instanceof TransformAccess) {
            return (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)connection, (String)"id");
        }
        return null;
    }

    public static String getClusterUrlsElseNull(ClickHouseStatementImpl statement) throws SQLException {
        ClickHouseConnection connection = statement.getConnection();
        if (connection instanceof TransformAccess) {
            return (String)TransformAccessUtils.getFromLopsAttributeMap((Object)connection, (String)"urls");
        }
        return null;
    }

    public static void onStatementStart(String sql, Integer connectionId, String clusterUrls) {
        try {
            ConnectionStats connectionStats;
            if (connectionId != null && (connectionStats = ClickHouseCollector.onConnectionStart(connectionId, clusterUrls, sql)) != null) {
                ClickHouseCollector.onStart(sql);
            }
        }
        catch (Exception statementOnStartException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)statementOnStartException);
        }
    }

    public static void onStatementError(String sql, Throwable e) {
        try {
            ClickHouseCollector.onConnectionException(e, sql);
            ClickHouseCollector.onThrowable(e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public static String getWriterSql(Writer writer) {
        AttributeAccess access = (AttributeAccess)writer;
        String table = (String)access.getLopsFileds()[0];
        String sql = (String)access.getLopsFileds()[1];
        String format = access.getLopsFileds()[2].toString();
        if (null != table) {
            return "INSERT INTO " + table + " FORMAT " + format;
        }
        if (null != sql) {
            String result = sql;
            if (!ClickHouseFormat.containsFormat((String)result)) {
                result = result + " FORMAT " + format;
            }
            return result;
        }
        return "unknown";
    }
}

