/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.redis.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.IntegerMap;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.redis.collector.RedisStats;
import com.lubanops.apm.plugin.redis.collector.RedisStatsStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RedisDetailAggregator
extends AbstractAggregator {
    private static final String MODEL_NAME_DETAIL = "detail";
    private static final int MAX_HOST_COUNT = 100;
    private static final int MAX_ACTION_COUNT = 200;
    private static final String REDIS_AGGREGATE_KEY_HOST = "host";
    private static final String REDIS_AGGREGATE_KEY_ACTION = "action";
    private static final String REDIS_AGGREGATE_KEY_TOTAL = "total";
    private static boolean isRedisDistinguishPort = true;
    private boolean parseRedis = false;
    private int parseRedisLength = 100;
    public static final IntegerMap REDIS_ACTION_MAP = new IntegerMap(200);
    public static final IntegerMap REDIS_CONNECTION_ID_MAP = new IntegerMap(100);
    private final RedisStatsStore redisStatsStore = new RedisStatsStore(200, 100);
    private final ParameterParser parameterParser = new ParameterParser();
    private ThreadLocal<RedisStats> statsLocal = new ThreadLocal();
    private ThreadLocal<Long> timeLocal = new ThreadLocal();
    private ThreadLocal<Boolean> errorLocal = new ThreadLocal();
    private ThreadLocal<String> hostLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
        this.parameterParser.parse(parameters);
    }

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        int maxActionId = REDIS_ACTION_MAP.size();
        int maxHostId = REDIS_CONNECTION_ID_MAP.size();
        for (int i = 0; i < maxActionId; ++i) {
            for (int j = 0; j < maxHostId; ++j) {
                MonitorDataRow m;
                RedisStats st;
                String host;
                String action = REDIS_ACTION_MAP.getResource(i);
                if (action == null || (host = REDIS_CONNECTION_ID_MAP.getResource(j)) == null || (st = this.redisStatsStore.get(new PrimaryKey(new String[]{action, host}))) == null || (m = st.harvest()) == null) continue;
                m.put((Object)REDIS_AGGREGATE_KEY_ACTION, (Object)action);
                m.put((Object)REDIS_AGGREGATE_KEY_HOST, (Object)host);
                result.add(m);
            }
        }
        return result;
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        MonitorDataRow result = null;
        String action = primaryKeyMap.get(REDIS_AGGREGATE_KEY_ACTION);
        if (action == null) {
            throw new ApmRuntimeException("get status by primary key,but action is null");
        }
        String host = primaryKeyMap.get(REDIS_AGGREGATE_KEY_HOST);
        if (host == null) {
            throw new ApmRuntimeException("get status by primary key,but host is null");
        }
        RedisStats redisStats = this.redisStatsStore.get(new PrimaryKey(new String[]{action, host}));
        if (null != redisStats) {
            result = redisStats.getStatus();
            result.put((Object)REDIS_AGGREGATE_KEY_ACTION, (Object)action);
            result.put((Object)REDIS_AGGREGATE_KEY_HOST, (Object)host);
        }
        return result;
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> statusList = new ArrayList<MonitorDataRow>();
        int maxHostId = REDIS_CONNECTION_ID_MAP.size();
        int maxActionId = REDIS_ACTION_MAP.size();
        for (int i = 0; i < maxActionId; ++i) {
            for (int j = 0; j < maxHostId; ++j) {
                MonitorDataRow m;
                RedisStats st;
                String host;
                String redisAction = REDIS_ACTION_MAP.getResource(i);
                if (redisAction == null || (host = REDIS_CONNECTION_ID_MAP.getResource(j)) == null || (st = this.redisStatsStore.get(new PrimaryKey(new String[]{redisAction, host}))) == null || (m = st.getStatus()) == null) continue;
                m.put((Object)REDIS_AGGREGATE_KEY_ACTION, (Object)redisAction);
                m.put((Object)REDIS_AGGREGATE_KEY_HOST, (Object)host);
                statusList.add(m);
            }
        }
        return statusList;
    }

    public long onStart(String action, String host) {
        if (!this.isEnable || this.statsLocal.get() != null) {
            return 0L;
        }
        RedisStats stats = this.redisStatsStore.get(new PrimaryKey(new String[]{action, host}));
        if (stats != null) {
            this.statsLocal.set(stats);
            long t = stats.onStart();
            this.timeLocal.set(t);
            this.hostLocal.set(host);
            return t;
        }
        return 0L;
    }

    public long getStartTime() {
        return this.timeLocal.get();
    }

    public boolean onThrowable(Throwable t, String traceId) {
        if (!this.isEnable) {
            return false;
        }
        RedisStats stats = this.statsLocal.get();
        Long start = this.timeLocal.get();
        if (stats != null && start != null) {
            this.errorLocal.set(true);
            stats.onThrowable(t);
            stats.setErrorTraceId(traceId);
            return true;
        }
        return false;
    }

    public void onFinally(boolean isBlob, long bits, String traceId) {
        if (!this.isEnable) {
            return;
        }
        RedisStats stats = this.statsLocal.get();
        Long start = this.timeLocal.get();
        Boolean error = this.errorLocal.get();
        if (error == null) {
            error = false;
        }
        this.statsLocal.remove();
        this.timeLocal.remove();
        this.errorLocal.remove();
        this.hostLocal.remove();
        if (stats != null && start != null) {
            stats.onFinally(start, isBlob, bits, traceId);
            TransactionCollector.collect((long)(System.nanoTime() - start), (boolean)error, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)"redis", (List)TransactionCollector.getTxName(), (String)"Redis");
        }
    }

    public void onFinally(boolean isBlob, boolean hit, long bits, String traceId, Boolean isRead) {
        if (!this.isEnable) {
            return;
        }
        RedisStats stats = this.statsLocal.get();
        Long start = this.timeLocal.get();
        Boolean error = this.errorLocal.get();
        if (error == null) {
            error = false;
        }
        this.statsLocal.remove();
        this.timeLocal.remove();
        this.errorLocal.remove();
        this.hostLocal.remove();
        if (stats != null && start != null) {
            stats.onFinally(start, isBlob, hit, bits, traceId, isRead);
            TransactionCollector.collect((long)(System.nanoTime() - start), (boolean)error, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)"redis", (List)TransactionCollector.getTxName(), (String)"Redis");
        }
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        if (collected == null || collected.isEmpty()) {
            return null;
        }
        int maxActionId = REDIS_ACTION_MAP.size();
        int maxHostId = REDIS_CONNECTION_ID_MAP.size();
        MonitorDataRow totalDataRow = new MonitorDataRow();
        HashMap<String, MonitorDataRow> hostMap = new HashMap<String, MonitorDataRow>(maxHostId);
        HashMap<String, MonitorDataRow> actionMap = new HashMap<String, MonitorDataRow>(maxActionId);
        for (MonitorDataRow row : collected) {
            String action;
            String host = (String)row.get((Object)REDIS_AGGREGATE_KEY_HOST);
            if (host != null) {
                MonitorDataRow v = (MonitorDataRow)hostMap.get(host);
                if (v == null) {
                    v = new MonitorDataRow();
                    v.put((Object)REDIS_AGGREGATE_KEY_HOST, (Object)host);
                    hostMap.put(host, v);
                }
                RedisStats.merge(row, v);
            }
            if ((action = (String)row.get((Object)REDIS_AGGREGATE_KEY_ACTION)) != null) {
                MonitorDataRow v = (MonitorDataRow)actionMap.get(action);
                if (v == null) {
                    v = new MonitorDataRow();
                    v.put((Object)REDIS_AGGREGATE_KEY_ACTION, (Object)action);
                    actionMap.put(action, v);
                }
                RedisStats.merge(row, v);
            }
            RedisStats.merge(row, totalDataRow);
        }
        HashMap<String, List<MonitorDataRow>> result = new HashMap<String, List<MonitorDataRow>>();
        result.put(REDIS_AGGREGATE_KEY_HOST, new ArrayList(hostMap.values()));
        result.put(REDIS_AGGREGATE_KEY_ACTION, new ArrayList(actionMap.values()));
        ArrayList<MonitorDataRow> totalRows = new ArrayList<MonitorDataRow>();
        totalRows.add(totalDataRow);
        result.put(REDIS_AGGREGATE_KEY_TOTAL, totalRows);
        return result;
    }

    public void clear() {
        this.setFull(false);
        this.setFullOutputted(false);
        this.redisStatsStore.clear();
    }

    public String getName() {
        return MODEL_NAME_DETAIL;
    }

    public static boolean isRedisDistinguishPort() {
        return isRedisDistinguishPort;
    }

    public static void setRedisDistinguishPort(boolean isRedisDistinguishPort) {
        RedisDetailAggregator.isRedisDistinguishPort = isRedisDistinguishPort;
    }

    public boolean onThrowableAsync(String action, String host, Throwable t, String traceId) {
        if (!this.isEnable) {
            return false;
        }
        RedisStats stats = this.redisStatsStore.get(new PrimaryKey(new String[]{action, host}));
        if (stats != null) {
            stats.onThrowable(t);
            stats.setErrorTraceId(traceId);
            return true;
        }
        return false;
    }

    public void onFinallyAsync(String action, String connectionId, long startTime, boolean isBlob, long bits, String traceId) {
        if (!this.isEnable()) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{action, connectionId});
        RedisStats redisStats = this.redisStatsStore.get(pk);
        if (redisStats != null && startTime > 0L) {
            redisStats.onFinally(startTime, isBlob, bits, traceId);
        }
    }

    public void onFinallyAsync(String action, String connectionId, long startTime, boolean isBlob, boolean hit, long bits, String traceId, Boolean isRead) {
        if (!this.isEnable()) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{action, connectionId});
        RedisStats redisStats = this.redisStatsStore.get(pk);
        if (redisStats != null && startTime > 0L) {
            redisStats.onFinally(startTime, isBlob, hit, bits, traceId, isRead);
        }
    }

    public boolean isParseRedis() {
        return this.parseRedis;
    }

    public int getParseRedisLength() {
        return this.parseRedisLength;
    }

    class ParameterParser {
        static final String MODEL_NAME_PARSE_BODY = "parseRedisBody";
        static final String MODEL_NAME_PARSE_BODY_LENGTH = "parseRedisBodyLength";
        static final String MODEL_NAME_DISTINGUISH_PORT = "isRedisDistinguishPort";

        ParameterParser() {
        }

        void parse(Map<String, String> parameters) {
            if (null == parameters || parameters.isEmpty()) {
                return;
            }
            boolean parseRedisBody = ConfigManager.isParseRedisBody();
            String parseRedisBodyStr = parameters.get(MODEL_NAME_PARSE_BODY);
            if (!StringUtils.isBlank((String)parseRedisBodyStr)) {
                parseRedisBody = Boolean.parseBoolean(parseRedisBodyStr);
            }
            RedisDetailAggregator.this.parseRedis = parseRedisBody;
            int parseRedisBodyLength = ConfigManager.getParseRedisLength();
            String parseRedisBodyLengthStr = parameters.get(MODEL_NAME_PARSE_BODY_LENGTH);
            if (!StringUtils.isBlank((String)parseRedisBodyLengthStr)) {
                parseRedisBodyLength = Integer.parseInt(parseRedisBodyLengthStr);
            }
            RedisDetailAggregator.this.parseRedisLength = parseRedisBodyLength;
            String isRedisDistinguishPortStr = parameters.get(MODEL_NAME_DISTINGUISH_PORT);
            if (!StringUtils.isBlank((String)isRedisDistinguishPortStr)) {
                RedisDetailAggregator.setRedisDistinguishPort(Boolean.parseBoolean(isRedisDistinguishPortStr));
            }
            this.updateStatsConfig(parameters);
        }

        private void updateStatsConfig(Map<String, String> parameters) {
            int redismaxActionId = REDIS_ACTION_MAP.size();
            int maxHostId = REDIS_CONNECTION_ID_MAP.size();
            for (int i = 0; i < redismaxActionId; ++i) {
                for (int j = 0; j < maxHostId; ++j) {
                    RedisStats st;
                    String host;
                    String redisaction = REDIS_ACTION_MAP.getResource(i);
                    if (redisaction == null || (host = REDIS_CONNECTION_ID_MAP.getResource(j)) == null || (st = RedisDetailAggregator.this.redisStatsStore.get(new PrimaryKey(new String[]{redisaction, host}))) == null) continue;
                    st.parseRange(parameters);
                }
            }
        }
    }
}

