/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.redisson.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.Tags;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.redis.collector.RedisCollector;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTags;
import com.lubanops.apm.plugin.redisson.collector.HostAndPort;
import io.netty.util.concurrent.Promise;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandAsyncService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.RedisURI;
import org.redisson.misc.RedissonPromise;

public class RedissonCommandInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (RedisCollector.getInstance().isEnable()) {
                TraceCollector.onStart((String)className, (String)methodName, (String)"Redisson");
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "RedissonCommandInterceptor", (Throwable)e);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (RedisCollector.getInstance().isEnable()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RedisCollector.getInstance().isEnable()) {
                String endPoint = this.getEndPoint(object, (NodeSource)args[1]);
                RedisCommand command = (RedisCommand)args[3];
                String commandName = command.getName();
                if (args[5] instanceof RedissonPromise) {
                    RedissonPromise redissonPromise = (RedissonPromise)args[5];
                    redissonPromise.onComplete((BiConsumer)new OnCompleteConsumer(endPoint, commandName, TraceCollector.onFinally((boolean)false), System.nanoTime(), redissonPromise));
                } else if (result instanceof CompletableFutureWrapper) {
                    ((CompletableFutureWrapper)result).thenAcceptAsync((Consumer)new OnCompleteConsumer(endPoint, commandName, TraceCollector.onFinally((boolean)false), System.nanoTime(), null));
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "RedissonCommandInterceptor", (Throwable)e);
        }
    }

    private Long getResultSize(RedissonPromise redissonPromise) {
        Long size = 0L;
        try {
            Field promiseField = redissonPromise.getClass().getDeclaredField("promise");
            promiseField.setAccessible(true);
            Promise promise = (Promise)promiseField.get(redissonPromise);
            Field resultField = promise.getClass().getSuperclass().getDeclaredField("result");
            resultField.setAccessible(true);
            Object result = resultField.get(promise);
            if (result != null) {
                if (result instanceof Long) {
                    size = 4L;
                } else if (result instanceof String) {
                    size = ((String)result).getBytes().length;
                } else if (result instanceof byte[]) {
                    size = ((byte[])result).length;
                } else if (result instanceof List) {
                    long sum = 0L;
                    if (result != null && ((List)result).size() > 0) {
                        for (Object item : (List)result) {
                            if (item instanceof String) {
                                sum += (long)((String)item).length();
                                continue;
                            }
                            if (!(item instanceof byte[])) continue;
                            sum += (long)((byte[])item).length;
                        }
                    }
                    size = sum;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    private String getEndPoint(Object object, NodeSource nodeSource) {
        String endPoint = this.toEndPoint(nodeSource);
        if (object instanceof CommandAsyncService) {
            ConnectionManager conn = ((CommandAsyncService)object).getConnectionManager();
            Field promiseField = null;
            try {
                if (conn != null && conn.isClusterMode()) {
                    promiseField = conn.getClass().getDeclaredField("lastClusterNode");
                    promiseField.setAccessible(true);
                    endPoint = this.parseUri(promiseField.get(conn));
                }
            }
            catch (Exception ignored) {
                LogFactory.getLogger().log(Level.FINE, "", (Throwable)ignored);
            }
        }
        return endPoint;
    }

    private String parseUri(Object uri) {
        String endPoint = "Unknown";
        if (uri != null && uri.getClass().getName().equals("java.net.URI")) {
            URI javaUri = (URI)uri;
            endPoint = HostAndPort.toHostAndPortString(javaUri.getHost(), javaUri.getPort());
        } else if (uri != null && uri.getClass().getName().equals("org.redisson.misc.RedisURI")) {
            RedisURI redisURI = (RedisURI)uri;
            endPoint = HostAndPort.toHostAndPortString(redisURI.getHost(), redisURI.getPort());
        }
        return endPoint;
    }

    private String toEndPoint(NodeSource nodeSource) {
        try {
            RedisURI uri;
            boolean isHighVersion = false;
            Field[] fields = nodeSource.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!"redisClient".equalsIgnoreCase(field.getName())) continue;
                isHighVersion = true;
                break;
            }
            if (nodeSource.getRedirect() != null && (uri = nodeSource.getAddr()) != null) {
                return this.parseUri(uri);
            }
            if (isHighVersion && nodeSource.getRedisClient() != null) {
                InetSocketAddress address = nodeSource.getRedisClient().getAddr();
                return HostAndPort.toHostAndPortString(address.getHostString(), address.getPort());
            }
            MasterSlaveEntry entry = nodeSource.getEntry();
            if (entry != null) {
                if (entry.getClient() != null) {
                    InetSocketAddress address = entry.getClient().getAddr();
                    return HostAndPort.toHostAndPortString(address.getHostString(), address.getPort());
                }
            } else if (nodeSource.getSlot() != null) {
                return "slot=" + nodeSource.getSlot();
            }
        }
        catch (Exception ignored) {
            LogFactory.getLogger().log(Level.FINE, "", (Throwable)ignored);
        }
        return "Unknown";
    }

    private class OnCompleteConsumer
    implements BiConsumer<Object, Throwable>,
    Consumer {
        private String hostAndPort;
        private String command;
        private SpanEvent spanEvent;
        private long startTime;
        private RedissonPromise redissonPromise;

        public OnCompleteConsumer(String hostAndPort, String command, SpanEvent spanEvent, long startTime, RedissonPromise redissonPromise) {
            this.hostAndPort = hostAndPort;
            this.command = command;
            this.spanEvent = spanEvent;
            this.startTime = startTime;
            this.redissonPromise = redissonPromise;
        }

        @Override
        public void accept(Object o, Throwable throwable) {
            try {
                String option = this.command;
                if (this.spanEvent != null) {
                    this.spanEvent.setAsync(true);
                    this.spanEvent.addTag(RedisTags.option.name(), option);
                    long timeUsedNano = System.nanoTime() - this.startTime;
                    this.spanEvent.addTag(Tags.asyncTimeUsed.name(), String.valueOf(timeUsedNano / 1000000L));
                    this.spanEvent.setTimeUsed(timeUsedNano);
                    this.spanEvent.addTag(RedisTags.host.name(), this.hostAndPort);
                }
                this.acceptSpanEvent(throwable, option);
            }
            catch (Throwable e) {
                TraceCollector.onError((SpanEvent)this.spanEvent, (Throwable)e);
            }
            if (this.spanEvent != null) {
                TraceCollector.sendSpanEvent((SpanEvent)this.spanEvent);
            }
        }

        public void accept(Object o) {
            this.accept(o, null);
        }

        private void acceptSpanEvent(Throwable throwable, String option) {
            String traceId = null;
            if (this.spanEvent != null) {
                traceId = this.spanEvent.getTraceId();
            }
            if (throwable != null) {
                RedisCollector.onThrowableAsync(this.command, this.hostAndPort, throwable, traceId);
                TraceCollector.onError((SpanEvent)this.spanEvent, (Throwable)throwable);
            } else {
                Boolean hit = true;
                if (this.redissonPromise != null) {
                    hit = this.redissonPromise.isSuccess();
                }
                if (this.spanEvent != null) {
                    this.spanEvent.addTag(RedisTags.hit.name(), String.valueOf(hit));
                }
                RedisCollector.onFinallyAsync(option, this.hostAndPort, this.startTime, hit, false, 0L, traceId, true);
            }
        }
    }
}

