/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.redisson.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.redis.collector.RedisCollector;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTags;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTransformHelper;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;

public class RedissonConnectionInterceptor
implements Interceptor {
    public static Set<String> OPERATION_MAPPING_WRITE = new HashSet<String>(Arrays.asList("getset", "set", "setbit", "setex ", "setnx ", "setrange", "strlen ", "mset", "msetnx ", "psetex", "incr ", "incrby ", "incrbyfloat", "decr ", "decrby ", "append ", "hmset", "hset", "hsetnx ", "hincrby", "hincrbyfloat", "hdel", "rpoplpush", "rpush", "rpushx", "lpush", "lpushx", "lrem", "ltrim", "lset", "brpoplpush", "linsert", "sadd", "sdiff", "sdiffstore", "sinterstore", "sismember", "srem", "sunion", "sunionstore", "sinter", "zadd", "zincrby", "zinterstore", "zrange", "zrangebylex", "zrangebyscore", "zrank", "zrem", "zremrangebylex", "zremrangebyrank", "zremrangebyscore", "zrevrange", "zrevrangebyscore", "zrevrank", "zunionstore", "xadd", "xdel", "del", "xtrim"));
    public static Set<String> OPERATION_MAPPING_READ = new HashSet<String>(Arrays.asList("getrange", "getbit ", "mget", "hvals", "hkeys", "hlen", "hexists", "hget", "hgetall", "hmget", "blpop", "brpop", "lindex", "llen", "lpop", "lrange", "rpop", "scard", "srandmember", "spop", "sscan", "smove", "zlexcount", "zscore", "zscan", "zcard", "zcount", "xget", "get", "xread", "xlen", "xrange", "xrevrange", "smembers"));

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            RedisConnection connection = (RedisConnection)object;
            Channel channel = connection.getChannel();
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
            String connectionId = remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
            String command = "";
            Object[] arguments = new Object[]{};
            if (args[0] instanceof CommandsData) {
                command = "BATCH_EXECUTE";
            } else if (args[0] instanceof CommandData) {
                CommandData commandData = (CommandData)args[0];
                command = commandData.getCommand().getName();
                arguments = commandData.getParams();
            }
            if (RedisCollector.getInstance().isEnable()) {
                TraceCollector.onStart((String)className, (String)command, (String)RedisCollector.getInstance().getCollectorName());
                RedisCollector.onStart(command, connectionId);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "RedissonConnectionInterceptor", (Throwable)e);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (RedisCollector.getInstance().isEnable()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            RedisConnection connection = (RedisConnection)object;
            Channel channel = connection.getChannel();
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
            String connectionId = remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
            if (RedisCollector.getInstance().isEnable()) {
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                String traceId = null;
                if (spanEvent != null) {
                    traceId = spanEvent.getTraceId();
                    spanEvent.addTag("host", connectionId);
                }
                if (RedisTransformHelper.isHitMethod(methodName)) {
                    boolean hit = result != null;
                    RedisCollector.onFinally(false, hit, 0L, traceId, true);
                    if (spanEvent != null && hit) {
                        spanEvent.addTag(RedisTags.hit.name(), "true");
                    }
                } else {
                    RedisCollector.onFinally(false, 0L, traceId);
                }
                TraceCollector.onFinally();
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "RedissonConnectionInterceptor", (Throwable)e);
        }
    }
}

