/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.redisson.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.redis.collector.RedisCollector;
import com.lubanops.apm.plugin.redisson.collector.RedissonCollector;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.redisson.Redisson;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;

public class RedissonConstructorInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            String version = Util.getJarVersionFromProtectionDomain((ProtectionDomain)Redisson.class.getProtectionDomain());
            RedissonCollector.setRedissonVersion(version);
            TraceCollector.onStart((String)className, (String)methodName, (String)"Redisson");
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "RedissonConstructorInterceptor", (Throwable)e);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (RedisCollector.getInstance().isEnable()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            SingleServerConfig singleServerConfig = (SingleServerConfig)this.getServerConfigByFieldName(args[0], "singleServerConfig");
            if (singleServerConfig != null) {
                String address = singleServerConfig.getAddress();
                if (address != null) {
                    RedissonCollector.getInstance().setClusterNodes(Arrays.asList(address));
                }
                RedissonCollector.getInstance().mode("standalone");
                return;
            }
            SentinelServersConfig sentinelServersConfig = (SentinelServersConfig)this.getServerConfigByFieldName(args[0], "sentinelServersConfig");
            if (sentinelServersConfig != null) {
                List sentinelAddresses = sentinelServersConfig.getSentinelAddresses();
                if (!sentinelAddresses.isEmpty()) {
                    RedissonCollector.getInstance().setClusterNodes(sentinelAddresses);
                }
                RedissonCollector.getInstance().mode("sentinel");
                return;
            }
            ClusterServersConfig clusterServersConfig = (ClusterServersConfig)this.getServerConfigByFieldName(args[0], "clusterServersConfig");
            if (clusterServersConfig != null) {
                List nodeAddresses = clusterServersConfig.getNodeAddresses();
                if (!nodeAddresses.isEmpty()) {
                    RedissonCollector.getInstance().setClusterNodes(nodeAddresses);
                }
                RedissonCollector.getInstance().mode("cluster");
                return;
            }
            MasterSlaveServersConfig masterSlaveServersConfig = (MasterSlaveServersConfig)this.getServerConfigByFieldName(args[0], "masterSlaveServersConfig");
            if (masterSlaveServersConfig != null) {
                Set slaveAddresses;
                ArrayList<String> allAddress = new ArrayList<String>();
                String masterAddress = masterSlaveServersConfig.getMasterAddress();
                if (masterAddress != null) {
                    allAddress.add(masterAddress);
                }
                if (!(slaveAddresses = masterSlaveServersConfig.getSlaveAddresses()).isEmpty()) {
                    allAddress.addAll(slaveAddresses);
                }
                RedissonCollector.getInstance().setClusterNodes(allAddress);
                RedissonCollector.getInstance().mode("master_slave");
                return;
            }
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, "Failed to AFTER process. {}", throwable);
        }
    }

    private Object getServerConfigByFieldName(Object args, String fieldName) {
        try {
            Config config = (Config)args;
            Field configField = config.getClass().getDeclaredField(fieldName);
            configField.setAccessible(true);
            return configField.get(config);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to AFTER process. {}", e);
            return null;
        }
    }
}

