/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.interceptor.StatsAroundInterceptor;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.bootstrap.utils.ExceptionUtil;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DubboInvocationStats
extends DefaultSectionStats
implements StatsAroundInterceptor {
    private static final String FIELD_LASTERROR = "lastError";
    private static final String FIELD_SLOWTRACEID = "slowTraceId";
    private static final String FIELD_ERRORTRACEID = "errorTraceId";
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private AtomicInteger sampleCount = new AtomicInteger(0);

    public static void merge(MonitorDataRow dataRowFrom, MonitorDataRow dataRowDes) {
        DefaultSectionStats.merge((MonitorDataRow)dataRowFrom, (MonitorDataRow)dataRowDes);
    }

    public void onError(Throwable t, String traceId) {
        super.onThrowable(t);
        String stackTrace = ExceptionUtil.getThrowableStackTrace((Throwable)t, (boolean)false);
        this.lastError.set(stackTrace);
        if (!StringUtils.isBlank((String)traceId)) {
            this.errorTraceId.set(traceId);
        }
    }

    void onResponse(long start, String traceId) {
        boolean flag = super.onFinally(System.nanoTime() - start);
        if (flag) {
            this.slowTraceId.set(traceId);
        }
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (null == row) {
            return null;
        }
        row.put((Object)FIELD_LASTERROR, this.lastError.getAndSet(null));
        row.put((Object)FIELD_SLOWTRACEID, this.slowTraceId.getAndSet(null));
        row.put((Object)FIELD_ERRORTRACEID, this.errorTraceId.getAndSet(null));
        this.sampleCount.set(0);
        return row;
    }

    AtomicInteger getSampleCount() {
        return this.sampleCount;
    }

    long getInvokeCount() {
        return this.invokeCount.get() - this.invokeCountOld;
    }
}

