/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.thread;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.utils.ThreadUtils;
import com.lubanops.apm.plugin.collector.thread.JVMThreadCollector;
import com.lubanops.apm.plugin.collector.thread.ThreadStats;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;

public class JVMThreadDetailAggregator
extends SinglePrimaryKeyAggregator<ThreadStats> {
    private ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    JVMThreadDetailAggregator() {
    }

    public String getName() {
        return "threadDetail";
    }

    protected String primaryKey() {
        return "threadName";
    }

    protected Class<ThreadStats> getValueType() {
        return ThreadStats.class;
    }

    public List<MonitorDataRow> harvest() {
        ThreadInfo[] threadInfos;
        int limit = 30;
        for (ThreadInfo threadInfo : threadInfos = this.threadMXBean.getThreadInfo(this.threadMXBean.getAllThreadIds(), JVMThreadCollector.getMaxDepth() + 1)) {
            ThreadStats threadStats;
            if (threadInfo == null) continue;
            String name = ThreadUtils.getOriginThreadName((String)threadInfo.getThreadName());
            String threadName = this.getThreadName(name);
            if (this.size() > limit) {
                threadStats = (ThreadStats)this.obtainValue(threadName);
                if (threadStats == null) continue;
                threadStats.setThreadInfo(threadInfo, JVMThreadCollector.getMaxDepth());
                continue;
            }
            threadStats = (ThreadStats)this.getValue(threadName);
            threadStats.setThreadInfo(threadInfo, JVMThreadCollector.getMaxDepth());
        }
        return super.harvest();
    }

    private String getThreadName(String name) {
        return name.replaceAll("\\d+", "*");
    }
}

