/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.gaussdb.zenith.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.bootstrap.plugin.sql.collector.JdbcConnectionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.JdbcStatsAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlStats;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlStatsConfig;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.gaussdb.zenith.collector.GaussDbStatsAggregator;
import java.util.Map;

public class GaussDbCollector
extends Collector {
    public static final GaussDbCollector INSTANCE = new GaussDbCollector();
    public static final SqlStatsConfig CONFIG = new SqlStatsConfig();
    public static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();
    public static final JdbcConnectionAggregator GAUSS_CONNECTION_AGGREGATOR = new JdbcConnectionAggregator();
    public static final JdbcStatsAggregator GAUSS_STATS_AGGREGATOR = new GaussDbStatsAggregator();
    public static final SqlExceptionAggregator SQL_EXCEPTION_AGGREGATOR = new SqlExceptionAggregator();

    public static void setDriverVersion(String v) {
        VERSION_AGGREGATOR.setVersion(v);
    }

    public static void onConnectionCreated(int connectionId) {
        if (connectionId >= 0) {
            GAUSS_CONNECTION_AGGREGATOR.onConnectionCreated(connectionId);
        }
    }

    public static void onConnectionDestroyed(int connectionId) {
        if (connectionId >= 0) {
            GAUSS_CONNECTION_AGGREGATOR.onConnectionDestoyed(connectionId);
        }
    }

    public static ConnectionStats onConnectionStart(int connectionId) {
        if (connectionId < 0) {
            return null;
        }
        return GAUSS_CONNECTION_AGGREGATOR.onConnectionStart(Integer.valueOf(connectionId));
    }

    public static void onConnectionException(Throwable t, String sql) {
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        GAUSS_CONNECTION_AGGREGATOR.onError(sql);
        SQL_EXCEPTION_AGGREGATOR.onThrowable(t, sql);
    }

    public static void onConnectionEnd(String sql, int updatedCount, int readRowCount) {
        if (updatedCount < 0) {
            updatedCount = 0;
        }
        if (readRowCount < 0) {
            readRowCount = 0;
        }
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        GAUSS_CONNECTION_AGGREGATOR.onFinally(sql, updatedCount, readRowCount, "GaussDb");
    }

    public static SqlStats onStart(String sql) {
        if (!INSTANCE.isEnable() || StringUtils.isBlank((String)sql)) {
            return null;
        }
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        return GAUSS_STATS_AGGREGATOR.onStart(sql);
    }

    public static void onThrowable(Throwable th) {
        GAUSS_STATS_AGGREGATOR.onThrowable(th);
    }

    public static void onFinally(int updatedRowCount, int readRowCount) {
        GAUSS_STATS_AGGREGATOR.onFinally(updatedRowCount, readRowCount);
    }

    public void parseParameter(Map<String, String> parameters) {
        if (parameters == null) {
            return;
        }
        GAUSS_STATS_AGGREGATOR.parseParameters(parameters);
    }

    public String getCollectorName() {
        return "GaussDb";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)GAUSS_CONNECTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)GAUSS_STATS_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)SQL_EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

