/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.postgresql.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.bootstrap.plugin.sql.collector.JdbcConnectionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.JdbcStatsAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlStats;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlStatsConfig;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.postgresql.collector.PgsqlStatsAggregator;
import java.util.Map;

public class PgsqlCollector
extends Collector {
    public static final PgsqlCollector INSTANCE = new PgsqlCollector();
    public static final SqlStatsConfig CONFIG = new SqlStatsConfig();
    public static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();
    public static final JdbcConnectionAggregator PG_CONNECTION_AGGREGATOR = new JdbcConnectionAggregator();
    public static final JdbcStatsAggregator PGSQL_STATS_AGGREGATOR = new PgsqlStatsAggregator();
    public static final SqlExceptionAggregator SQL_EXCEPTION_AGGREGATOR = new SqlExceptionAggregator();

    public static void setDriverVersion(String v) {
        VERSION_AGGREGATOR.setVersion(v);
    }

    public static void onConnectionCreated(int connectionId) {
        if (connectionId >= 0) {
            PG_CONNECTION_AGGREGATOR.onConnectionCreated(connectionId);
        }
    }

    public static void onConnectionDestroyed(int connectionId) {
        if (connectionId >= 0) {
            PG_CONNECTION_AGGREGATOR.onConnectionDestoyed(connectionId);
        }
    }

    public static ConnectionStats onConnectionStart(int connectionId, String sql) {
        if (connectionId < 0) {
            return null;
        }
        return PG_CONNECTION_AGGREGATOR.onConnectionStart(Integer.valueOf(connectionId));
    }

    public static void onConnectionException(Throwable t, String sql) {
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        PG_CONNECTION_AGGREGATOR.onError(sql);
        SQL_EXCEPTION_AGGREGATOR.onThrowable(t, sql);
    }

    public static void onConnectionEnd(String sql, int updatedCount, int readRowCount) {
        if (updatedCount < 0) {
            updatedCount = 0;
        }
        if (readRowCount < 0) {
            readRowCount = 0;
        }
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        PG_CONNECTION_AGGREGATOR.onFinally(sql, updatedCount, readRowCount, "Postgresql");
    }

    public static SqlStats onStart(String sql) {
        if (!INSTANCE.isEnable() || StringUtils.isBlank((String)sql)) {
            return null;
        }
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        return PGSQL_STATS_AGGREGATOR.onStart(sql);
    }

    public static void onThrowable(Throwable th) {
        PGSQL_STATS_AGGREGATOR.onThrowable(th);
    }

    public static void onFinally(int updatedRowCount, int readRowCount) {
        PGSQL_STATS_AGGREGATOR.onFinally(updatedRowCount, readRowCount);
    }

    public void parseParameter(Map<String, String> parameters) {
        if (parameters == null) {
            return;
        }
        PGSQL_STATS_AGGREGATOR.parseParameters(parameters);
    }

    public String getCollectorName() {
        return "Postgresql";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)PG_CONNECTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)PGSQL_STATS_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)SQL_EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

