/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaHelper;
import com.lubanops.apm.bootstrap.plugin.kafka.utils.KafkaUtils;
import com.lubanops.apm.bootstrap.plugin.kafka.utils.MbeanUtils;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class KafkaConsumerTopicAggregator
extends AbstractAggregator {
    private static final Logger LOGGER = LogFactory.getLogger();
    private MBeanServer server;
    private final Map<String, Map<String, Double>> recordsConsumedTotalMap = new HashMap<String, Map<String, Double>>();
    private final Map<String, Map<String, Double>> bytesConsumedTotalMap = new HashMap<String, Map<String, Double>>();

    public String getName() {
        return "topic";
    }

    private MBeanServer getServer() {
        if (this.server == null) {
            this.server = ManagementFactory.getPlatformMBeanServer();
        }
        return this.server;
    }

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        HashMap<String, MonitorDataRow> resultMap = new HashMap<String, MonitorDataRow>();
        try {
            ObjectName objName = new ObjectName("kafka.consumer:type=consumer-fetch-manager-metrics,client-id=*,topic=*");
            Set<ObjectName> nn = this.getServer().queryNames(objName, null);
            int count = 0;
            for (ObjectName on : nn) {
                MonitorDataRow map;
                if (++count > 100) break;
                String clientId = on.getKeyProperty("client-id");
                String seqId = KafkaHelper.CONSUMERINFO.getReformatIdSeq(clientId);
                String ips = KafkaHelper.CONSUMERINFO.getIp(clientId);
                if (ips == null) continue;
                String topic = on.getKeyProperty("topic");
                if (seqId != null) {
                    String reformattedIdPrefix = clientId.substring(0, clientId.lastIndexOf("-") + 1);
                    String reformattedId = reformattedIdPrefix + "{sequenceId}" + "|" + ips;
                    String resultMapKey = reformattedId + "|" + topic;
                    map = (MonitorDataRow)resultMap.get(resultMapKey);
                    if (map == null) {
                        map = new MonitorDataRow();
                        map.put((Object)"id", (Object)reformattedId);
                        map.put((Object)"topic", (Object)topic);
                        resultMap.put(resultMapKey, map);
                    }
                    this.setDataCumulated(map, on, clientId, seqId);
                    continue;
                }
                map = new MonitorDataRow();
                map.put((Object)"id", (Object)(clientId + "|" + ips));
                map.put((Object)"topic", (Object)topic);
                this.setData(map, on);
                result.add(map);
            }
            result.addAll(resultMap.values());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "\u91c7\u96c6topic\u76d1\u63a7\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    private void setData(MonitorDataRow row, ObjectName objName) {
        try {
            row.put((Object)"bytesConsumedRate", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "bytes-consumed-rate"));
            row.put((Object)"fetchSizeAvg", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "fetch-size-avg"));
            row.put((Object)"fetchSizeMax", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "fetch-size-max"));
            row.put((Object)"recordsConsumedRate", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "records-consumed-rate"));
            row.put((Object)"recordsPerRequestAvg", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "records-per-request-avg"));
            Double currentRecordsConsumedTotal = MbeanUtils.getIntValue(this.getServer(), objName, "records-consumed-total");
            Double currentBytesConsumedTotal = MbeanUtils.getIntValue(this.getServer(), objName, "bytes-consumed-total");
            Double[] diffs = this.saveDataSentTotal((String)row.get((Object)"id"), (String)row.get((Object)"topic"), currentRecordsConsumedTotal, currentBytesConsumedTotal);
            row.put((Object)"recordConsumedTotal", (Object)diffs[0]);
            row.put((Object)"bytesConsumedTotal", (Object)diffs[1]);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "\u91c7\u96c6topic\u76d1\u63a7\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void setDataCumulated(MonitorDataRow row, ObjectName objName, String clientId, String seqId) {
        try {
            KafkaUtils.appendSeqId(row, seqId);
            Double cumulatedBytesConsumedRate = KafkaUtils.getRowValOrZero(row, "bytesConsumedRate");
            Double cumulatedFetchSizeAvg = KafkaUtils.getRowValOrZero(row, "fetchSizeAvg");
            Double cumulatedFetchSizeMax = KafkaUtils.getRowValOrZero(row, "fetchSizeMax");
            Double cumulatedRecordsConsumedRate = KafkaUtils.getRowValOrZero(row, "recordsConsumedRate");
            Double cumulatedRecordsPerRequestAvg = KafkaUtils.getRowValOrZero(row, "recordsPerRequestAvg");
            row.put((Object)"bytesConsumedRate", (Object)KafkaUtils.getSum(cumulatedBytesConsumedRate, MbeanUtils.getIntValue(this.getServer(), objName, "bytes-consumed-rate")));
            row.put((Object)"fetchSizeAvg", (Object)KafkaUtils.getRoughAvg(cumulatedFetchSizeAvg, MbeanUtils.getIntValue(this.getServer(), objName, "fetch-size-avg")));
            row.put((Object)"fetchSizeMax", (Object)KafkaUtils.getMax(cumulatedFetchSizeMax, MbeanUtils.getIntValue(this.getServer(), objName, "fetch-size-max")));
            row.put((Object)"recordsConsumedRate", (Object)KafkaUtils.getSum(cumulatedRecordsConsumedRate, MbeanUtils.getIntValue(this.getServer(), objName, "records-consumed-rate")));
            row.put((Object)"recordsPerRequestAvg", (Object)KafkaUtils.getRoughAvg(cumulatedRecordsPerRequestAvg, MbeanUtils.getIntValue(this.getServer(), objName, "records-per-request-avg")));
            Double currentRecordsConsumedTotal = MbeanUtils.getIntValue(this.getServer(), objName, "records-consumed-total");
            Double currentBytesConsumedTotal = MbeanUtils.getIntValue(this.getServer(), objName, "bytes-consumed-total");
            String topic = (String)row.get((Object)"topic");
            Double[] diffs = this.saveDataSentTotal(clientId, topic, currentRecordsConsumedTotal, currentBytesConsumedTotal);
            Double recordsConsumedTotal = KafkaUtils.getRowValOrZero(row, "recordConsumedTotal");
            Double bytesConsumedTotal = KafkaUtils.getRowValOrZero(row, "bytesConsumedTotal");
            row.put((Object)"recordConsumedTotal", (Object)(recordsConsumedTotal + diffs[0]));
            row.put((Object)"bytesConsumedTotal", (Object)(bytesConsumedTotal + diffs[1]));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "\u91c7\u96c6topic\u76d1\u63a7\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private Double[] saveDataSentTotal(String clientId, String topic, Double currentRecordsConsumedTotal, Double currentBytesConsumedTotal) {
        if (currentRecordsConsumedTotal == null) {
            currentRecordsConsumedTotal = 0.0;
        }
        if (currentBytesConsumedTotal == null) {
            currentBytesConsumedTotal = 0.0;
        }
        if (!this.recordsConsumedTotalMap.containsKey(clientId)) {
            this.recordsConsumedTotalMap.put(clientId, new HashMap());
        }
        if (!this.bytesConsumedTotalMap.containsKey(clientId)) {
            this.bytesConsumedTotalMap.put(clientId, new HashMap());
        }
        Map<String, Double> recordsConsumedInnerMap = this.recordsConsumedTotalMap.get(clientId);
        Map<String, Double> bytesConsumedInnerMap = this.bytesConsumedTotalMap.get(clientId);
        if (!recordsConsumedInnerMap.containsKey(topic)) {
            recordsConsumedInnerMap.put(topic, 0.0);
        }
        if (!bytesConsumedInnerMap.containsKey(topic)) {
            bytesConsumedInnerMap.put(topic, 0.0);
        }
        Double preRecordsConsumedTotal = recordsConsumedInnerMap.get(topic);
        Double preBytesConsumedTotal = bytesConsumedInnerMap.get(topic);
        recordsConsumedInnerMap.put(topic, currentRecordsConsumedTotal);
        bytesConsumedInnerMap.put(topic, currentBytesConsumedTotal);
        return new Double[]{currentRecordsConsumedTotal - preRecordsConsumedTotal, currentBytesConsumedTotal - preBytesConsumedTotal};
    }

    public void removeClientIdFromMaps(String clientId) {
        this.recordsConsumedTotalMap.remove(clientId);
        this.bytesConsumedTotalMap.remove(clientId);
    }

    public void clear() {
    }

    public void parseParameters(Map<String, String> parameters) {
    }
}

