/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class EsClientStats
extends DefaultSectionStats {
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private final AtomicLong definitiveFailureCount = new AtomicLong();
    private final AtomicLong trackFailureCount = new AtomicLong();

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    public void onDefinitiveFailure(String traceId) {
        this.setErrorTraceId(traceId);
        this.definitiveFailureCount.incrementAndGet();
    }

    public void onTrackFailure() {
        this.trackFailureCount.incrementAndGet();
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"lastError", (Object)this.lastError.get());
        row.put((Object)"slowTraceId", (Object)this.slowTraceId.get());
        row.put((Object)"errorTraceId", (Object)this.errorTraceId.get());
        long definitiveFailureCountVal = this.definitiveFailureCount.get();
        row.put((Object)"definitiveFailureCount", (Object)definitiveFailureCountVal);
        row.put((Object)"retryCount", (Object)(this.trackFailureCount.get() - definitiveFailureCountVal));
        return row;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row == null) {
            return null;
        }
        row.put((Object)"lastError", this.lastError.getAndSet(null));
        row.put((Object)"slowTraceId", this.slowTraceId.getAndSet(null));
        row.put((Object)"errorTraceId", this.errorTraceId.getAndSet(null));
        long definitiveFailureCountVal = this.definitiveFailureCount.getAndSet(0L);
        row.put((Object)"definitiveFailureCount", (Object)definitiveFailureCountVal);
        row.put((Object)"retryCount", (Object)(this.trackFailureCount.getAndSet(0L) - definitiveFailureCountVal));
        return row;
    }
}

