/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import java.util.HashMap;
import java.util.Map;

public final class CoapUtils {
    public static void saveToLopsAttribute(Object object, String key, Object val) {
        TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)key, (Object)val);
    }

    public static void saveSpanEvent(Object object) {
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        CoapUtils.saveSpanEvent(object, spanEvent);
    }

    public static void saveSpanEvent(Object object, SpanEvent spanEvent) {
        if (spanEvent != null && object instanceof TransformAccess) {
            TransformAccess transformAccess = (TransformAccess)object;
            if (transformAccess.getLopsAttribute() == null) {
                transformAccess.setLopsAttribute(new HashMap());
            }
            Map map = (Map)transformAccess.getLopsAttribute();
            map.put("spanEvent", spanEvent);
            map.put("gtraceId", TraceCollector.G_TRACE_ID_THREAD_LOCAL.get());
            map.put("userFlag", TraceCollector.USER_FLAG_THREAD_LOCAL.get());
        }
    }

    public static <T> T getFromLopsAttribute(Object object, String key) {
        return (T)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)key);
    }

    public static String trimSuffix(String uri) {
        int i = uri.indexOf(63);
        return i <= 0 ? uri : uri.substring(0, i);
    }

    public static int getCoapCodeInInt(String code) {
        if (code == null || code.length() != 4) {
            return 500;
        }
        int numOfDigits = 0;
        int val = 0;
        for (char c : code.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            ++numOfDigits;
            int num = c - 48;
            val = val * 10 + num;
        }
        if (numOfDigits == 3 && code.charAt(1) == '.') {
            return val;
        }
        return 500;
    }
}

