/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.server.collector;

import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.plugin.coapcalifornium.stats.CoapStats;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoapServerAggregator
extends UrlAggregator<CoapStats> {
    private static final String URL = "url";
    private static final String METHOD = "method";
    private static final String REQUEST_TYPE = "requestType";

    public void parseParameters(Map<String, String> parameters) {
    }

    public Map<String, Object> onStart(String url, String methodType, String requestType) {
        if (!this.isEnable) {
            return null;
        }
        HashMap<String, Object> collectorContext = new HashMap<String, Object>();
        CoapStats stats = (CoapStats)this.getValue(new String[]{url, methodType, requestType});
        if (stats != null) {
            long startTime = stats.onStart();
            collectorContext.put("startTime", startTime);
            collectorContext.put("statsBase", (Object)stats);
            return collectorContext;
        }
        return null;
    }

    public void onError(CoapStats stats, String traceId) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null) {
            stats.onError();
            stats.setErrorTraceId(traceId);
        }
    }

    public void onFinally(CoapStats stats, Long startTime, String traceId) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null && startTime != null && stats.onFinally(System.nanoTime() - startTime)) {
            stats.setSlowTraceId(traceId);
        }
    }

    public String getName() {
        return "detail";
    }

    protected Class<CoapStats> getValueType() {
        return CoapStats.class;
    }

    protected int primaryKeyLength() {
        return 3;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(URL, METHOD, REQUEST_TYPE);
    }

    public String getUrlKey() {
        return URL;
    }
}

