/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.server.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.coapcalifornium.CoapUtils;
import com.lubanops.apm.plugin.coapcalifornium.server.collector.CoapSampleFilter;
import com.lubanops.apm.plugin.coapcalifornium.server.collector.CoapServerCollector;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;

public class DeliverRequestInterceptor
implements Interceptor {
    public DeliverRequestInterceptor() {
        CoapServerCollector.setVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)CoapServer.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (CoapServerCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof Exchange) {
                Exchange exchange = (Exchange)args[0];
                Request request = exchange.getRequest();
                OptionSet optionSet = request.getOptions();
                List arbitraryOptions = optionSet.getOthers();
                Map<String, String> ids = this.getIds(arbitraryOptions);
                String url = request.getURI();
                String method = request.getCode().name();
                String requestType = request.getType().name();
                StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, ids.get("traceId"), ids.get("spanId"), ids.get("gtraceId"));
                startTraceRequest.setKind("CoapServer");
                startTraceRequest.setSource(url);
                startTraceRequest.setRealSource(url);
                startTraceRequest.setSourceEventId(ids.get("sourceEventId"));
                startTraceRequest.setDomainId(ids.get("domainId"));
                startTraceRequest.setSampleFilter((SampleFilter)new CoapSampleFilter());
                startTraceRequest.setHttpMethod(method);
                SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                if (spanEvent != null) {
                    spanEvent.addTag("coap.msg.requestType", requestType);
                    spanEvent.addTag("coap.msg.direction", "incoming");
                    spanEvent.addTag("coap.mid", String.valueOf(request.getMID()));
                }
                TraceCollector.USER_FLAG_THREAD_LOCAL.set(ids.get("userFlag"));
                String envId = ids.get("envId");
                Map<String, Object> collectorContext = CoapServerCollector.onStart(url, method, requestType, envId == null || envId.length() == 0 ? "unknown" : envId);
                TraceCollector.onFinally((boolean)false);
                CoapUtils.saveSpanEvent(exchange, spanEvent);
                CoapUtils.saveToLopsAttribute(exchange, "serverCollectorContext", collectorContext);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
        return new Object[0];
    }

    private Map<String, String> getIds(List<Option> arbitraryOptions) {
        String domainId = "";
        String traceId = "";
        String spanId = "";
        String sourceEventId = "";
        String envId = "";
        String gTraceId = "";
        for (Option option : arbitraryOptions) {
            String val = option.getStringValue();
            switch (option.getNumber()) {
                case 1002: {
                    domainId = val;
                    break;
                }
                case 1003: {
                    traceId = val;
                    break;
                }
                case 1004: {
                    spanId = val;
                    break;
                }
                case 1005: {
                    sourceEventId = val;
                    break;
                }
                case 1001: {
                    envId = val;
                    break;
                }
                case 1006: {
                    gTraceId = val;
                    break;
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("domainId", domainId);
        map.put("traceId", traceId);
        map.put("spanId", spanId);
        map.put("sourceEventId", sourceEventId);
        map.put("envId", envId);
        map.put("gtraceId", gTraceId);
        return map;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

