/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.url.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlUserStats;
import com.lubanops.apm.bootstrap.utils.ConcurrentUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class UrlUserAggregator
extends SinglePrimaryKeyAggregator<UrlUserStats> {
    public String getName() {
        return "user";
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    protected Class<UrlUserStats> getValueType() {
        return UrlUserStats.class;
    }

    public void onStart(String clusterId) {
        if (clusterId == null) {
            clusterId = "user";
        }
        UrlUserStats value = (UrlUserStats)this.getValue(clusterId);
        ConcurrentUtil.setMaxValue((AtomicLong)value.getConcurrentMax(), (long)value.getRunningCount().incrementAndGet());
    }

    public void onFinally(long t, int code, String clusterId, boolean hasError) {
        UrlUserStats value = (UrlUserStats)this.getValue(clusterId);
        value.getInvokeCount().incrementAndGet();
        value.getTotalTime().addAndGet(t);
        ConcurrentUtil.setMaxValue((AtomicLong)value.getMaxTime(), (long)t);
        value.getRunningCount().decrementAndGet();
        if (hasError) {
            value.getErrorCount().incrementAndGet();
        }
        if (code >= 100 && code < 200) {
            value.getTotal1xxCount().incrementAndGet();
        } else if (code < 300) {
            value.getTotal2xxCount().incrementAndGet();
        } else if (code < 400) {
            value.getTotal3xxCount().incrementAndGet();
        } else if (code < 500) {
            value.getTotal4xxCount().incrementAndGet();
        } else if (code < 600) {
            value.getTotal5xxCount().incrementAndGet();
        }
    }

    protected String primaryKey() {
        return "clusterId";
    }

    public void parseParameters(Map<String, String> parameters) {
    }
}

