/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.grpc.server.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.grpc.server.collector.ClusterAggregator;
import com.lubanops.apm.plugin.grpc.server.collector.ServerAggregator;
import com.lubanops.apm.plugin.grpc.server.stats.ServerClusterStatsBase;
import java.util.Map;

public class SeverCollector
extends Collector {
    public static final SeverCollector INSTANCE = new SeverCollector();
    static ServerAggregator serverAggregator = new ServerAggregator();
    static ClusterAggregator clusterAggregator = new ClusterAggregator();
    static ThreadLocal<Map<String, Object>> context = new ThreadLocal();

    public void parseParameter(Map<String, String> parameters) {
    }

    public static Map<String, Object> onStart(String method, String envId) {
        String clusterId = "user";
        if (!StringUtils.isBlank((String)envId)) {
            clusterId = envId;
        }
        Map<String, Object> map = serverAggregator.onStart(method);
        clusterAggregator.onStart(clusterId, map);
        return map;
    }

    public static void onError() {
        Map<String, Object> map = context.get();
        if (map != null) {
            Object stats = map.get("statsBase");
            Object clusterStats = map.get("clusterStatsBase");
            if (stats != null && stats instanceof UrlStats) {
                serverAggregator.onError((UrlStats)stats);
                clusterAggregator.onError((ServerClusterStatsBase)((Object)clusterStats));
            }
        }
    }

    public static void onFinally() {
        Map<String, Object> map = context.get();
        if (map != null) {
            Object stats = map.get("statsBase");
            Long startTime = (Long)map.get("startTime");
            Object clusterStats = map.get("clusterStatsBase");
            if (stats != null && stats instanceof UrlStats) {
                serverAggregator.onFinally((UrlStats)stats, startTime);
                clusterAggregator.onFinally((ServerClusterStatsBase)((Object)clusterStats), startTime);
            }
            context.set(null);
        }
    }

    public String getCollectorName() {
        return "GRPCServer";
    }

    public static void setContext(Map<String, Object> map) {
        context.set(map);
    }

    public static Map<String, Object> getContext() {
        return context.get();
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)serverAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)clusterAggregator);
        INSTANCE.register();
    }
}

