/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql5.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.mysql5.utils.Mysql5Utils;
import com.mysql.jdbc.ConnectionImpl;
import java.security.ProtectionDomain;

public class MysqlConnectionInterceptor
implements Interceptor {
    public MysqlConnectionInterceptor() {
        MysqlCollector.setDriverVersion((String)Util.getJarVersionFromProtectionDomain((ProtectionDomain)ConnectionImpl.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        Mysql5Utils.setConnecting(true);
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ConnectionImpl connection = (ConnectionImpl)object;
            if (object instanceof AttributeAccess) {
                Object[] fileds = ((AttributeAccess)object).getLopsFileds();
                String host = (String)fileds[0];
                Integer port = (Integer)fileds[1];
                String dbName = Helper.getDbName((String)(host + ":" + port), (String)connection.getCatalog());
                Integer id = Helper.CONNECTION_TARGET_MAP.registerResource(dbName);
                if (object instanceof TransformAccess) {
                    ((TransformAccess)object).setLopsAttribute((Object)id);
                }
                MysqlCollector.onConnectionCreated((Integer)id);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
        finally {
            Mysql5Utils.setConnecting(false);
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }
}

