/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector.consumer;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.plugin.dubbo.collector.DubboClusterAggregator;
import com.lubanops.apm.plugin.dubbo.collector.DubboInvocationAggregator;
import com.lubanops.apm.plugin.dubbo.collector.DubboResultCodeAggregator;
import com.lubanops.apm.plugin.dubbo.collector.DubboThreadPoolAggregator;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public class DubboConsumerCollector
extends Collector {
    private static DefaultVersionAggregator versionAggregator = new DefaultVersionAggregator();
    public static final DubboConsumerCollector INSTANCE = new DubboConsumerCollector();
    private static DubboInvocationAggregator invocationAggregator = new DubboInvocationAggregator();
    private static DubboClusterAggregator clusterAggregator = new DubboClusterAggregator();
    private static DubboResultCodeAggregator resultCodeAggregator = new DubboResultCodeAggregator();
    private static DubboThreadPoolAggregator threadPoolAggregator = new DubboThreadPoolAggregator();

    public static void onStart(String serviceUniqueName, String method) {
        invocationAggregator.onStart(serviceUniqueName, method);
    }

    public static void onResponse(long startTime, String traceId, String serviceUniqueName, String method, String clusterId, boolean isSuccess) {
        invocationAggregator.onResponse(startTime, traceId, serviceUniqueName, method);
        clusterAggregator.onComplete(startTime, clusterId);
        if (isSuccess) {
            resultCodeAggregator.onFinally(method, "success");
        }
    }

    public static void onError(Throwable th, long startTime, String traceId, String serviceUniqueName, String method, String clusterId) {
        invocationAggregator.onError(th, startTime, traceId, serviceUniqueName, method);
        clusterAggregator.onError(th, startTime, clusterId);
        resultCodeAggregator.onFinally(method, "failure");
    }

    public void onThreadPoolCreated(String poolId, ThreadPoolExecutor pool, String poolType) {
        threadPoolAggregator.register(poolId, pool, poolType);
    }

    public void setVersion(String version) {
        versionAggregator.setVersion(version);
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "DubboConsumer";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)invocationAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)clusterAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)resultCodeAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)threadPoolAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)versionAggregator);
        INSTANCE.register();
    }
}

