/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.trace;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.api.HarvestListener;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.apm.APMCollector;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceReportService;
import com.lubanops.apm.bootstrap.utils.AgentUtils;
import com.lubanops.apm.core.common.ConnectionException;
import com.lubanops.apm.core.executor.standalone.ServiceThread;
import com.lubanops.apm.core.transfer.InvokerService;
import com.lubanops.apm.core.transfer.TransferInvokerService;
import com.lubanops.apm.core.utils.ReportDataBuilder;
import com.lubanops.apm.integration.access.MessageIdGenerator;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.access.inbound.EventDataBody;
import com.lubanops.apm.integration.access.inbound.EventDataRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

public class TraceReportServiceImpl
implements TraceReportService {
    private static final int MAX_SPAN_EVENT_COUNT = 512;
    private static final String SPAN_EVENT_DATA_TYPE = "SpanEventData";
    private static final ArrayBlockingQueue<SpanEvent> SPAN_EVENT_DATA_QUEUE = new ArrayBlockingQueue(512);
    private static final Logger LOGGER = LogFactory.getLogger();
    private InvokerService invokerService = TransferInvokerService.getInstance();
    private HarvestListener<APMCollector> harvestListener;
    private List<SpanEventSendThread> threadList = new ArrayList<SpanEventSendThread>();
    private boolean closed = false;
    private boolean hasException = Boolean.FALSE;
    private static volatile TraceReportServiceImpl instance;

    public static synchronized TraceReportServiceImpl getInstance() {
        if (instance == null) {
            instance = new TraceReportServiceImpl();
        }
        return instance;
    }

    public TraceReportServiceImpl() {
        int threadCount = AgentConfigManager.getEventThreadCount();
        for (int i = 0; i < threadCount; ++i) {
            SpanEventSendThread spanEventSendThread = new SpanEventSendThread();
            spanEventSendThread.start();
            this.threadList.add(spanEventSendThread);
        }
        this.harvestListener = new HarvestListener<APMCollector>(){

            public void onHarvest(APMCollector collector, long time) {
                collector.monitorQueueSize((long)SPAN_EVENT_DATA_QUEUE.size(), AgentUtils.getObjectSize((Object)SPAN_EVENT_DATA_QUEUE));
            }
        };
        APMCollector.INSTANCE.listenHarvest(this.harvestListener);
    }

    public void dispose() throws ApmRuntimeException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        int timeout = 1000;
        if (timeout > 0) {
            long start = System.currentTimeMillis();
            while (SPAN_EVENT_DATA_QUEUE.isEmpty() && System.currentTimeMillis() - start < (long)timeout) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
            }
        }
        SPAN_EVENT_DATA_QUEUE.clear();
        for (SpanEventSendThread spanEventSendThread : this.threadList) {
            spanEventSendThread.shutdown(true);
        }
        this.threadList.clear();
    }

    public void offerEvent(SpanEvent spanEvent) {
        if (spanEvent == null) {
            return;
        }
        boolean success = SPAN_EVENT_DATA_QUEUE.offer(spanEvent);
        if (!success) {
            String json = APIService.getJsonApi().toJSONString((Object)spanEvent);
            int length = json.getBytes().length;
            APMCollector.onDiscard((String)SPAN_EVENT_DATA_TYPE, (long)length);
            LogFactory.getLogger().warningFullQueue("spanevent data queue is full,data discarded:" + spanEvent.toString());
        } else {
            APMCollector.onStart((String)SPAN_EVENT_DATA_TYPE, (int)SPAN_EVENT_DATA_QUEUE.size());
        }
    }

    public class SpanEventSendThread
    extends ServiceThread {
        private EventDataRequest request;
        private long length;

        public SpanEventSendThread() {
            super(TraceReportServiceImpl.class.getSimpleName());
        }

        @Override
        public void run() {
            LOGGER.info("[TRACE REPORTER]reporter start.");
            while (!this.isStopped()) {
                this.report();
            }
            LOGGER.info("[TRACE REPORTER]reporter stop.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean report() {
            SpanEvent spanEvent = null;
            long endTime = 0L;
            long startTime = 0L;
            String logClassName = null;
            String logMethodName = null;
            try {
                spanEvent = (SpanEvent)SPAN_EVENT_DATA_QUEUE.take();
                startTime = System.currentTimeMillis();
                this.request = new EventDataRequest();
                this.request.setMessageId(MessageIdGenerator.generateMessageId());
                this.request.setHeader(ReportDataBuilder.buildEventDataHeader());
                this.request.getHeader().setNeedResponse(false);
                EventDataBody eventDataBody = ReportDataBuilder.buildEventDataBody(spanEvent);
                this.request.setBody(eventDataBody);
                this.length = this.request.getBodyBytes().length;
                if (this.length > 1000000L) {
                    LOGGER.log(Level.SEVERE, "data\u8fc7\u5927:" + this.request.getBodyString().substring(0, 1000));
                    HashMap<String, String> bodyMap = new HashMap<String, String>();
                    bodyMap.put("msg", "\u6570\u636e\u8d85\u8fc71M\u5df2\u4e22\u5f03");
                    eventDataBody.setTags(bodyMap);
                    this.length = eventDataBody.toString().getBytes().length;
                }
                logClassName = this.request.getBody().getClassName();
                logMethodName = this.request.getBody().getMethod();
                this.sendSpanEvent();
            }
            catch (Throwable e) {
                Level level = Level.SEVERE;
                if (TraceReportServiceImpl.this.hasException) {
                    level = Level.FINE;
                }
                LOGGER.log(level, "failed to send data,error message:" + e.getMessage() + ",type:" + e.getClass().getName(), e);
                LOGGER.log(Level.SEVERE, "data:" + logClassName + "." + logMethodName);
                APMCollector.onThrowable((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)this.length, (Throwable)e);
                TraceReportServiceImpl.this.hasException = true;
            }
            finally {
                if (startTime > 0L) {
                    endTime = System.currentTimeMillis();
                    APMCollector.onFinally((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)(endTime - startTime));
                }
            }
            return true;
        }

        public void sendSpanEvent() throws ConnectionException, IOException {
            LOGGER.log(Level.FINE, String.format("[debug mode]sending message:[%s]", this.request.getBodyString()));
            if (TraceReportServiceImpl.this.invokerService.isSendEnable()) {
                TraceReportServiceImpl.this.invokerService.sendDataReport((MessageWrapper)this.request);
                LOGGER.log(Level.FINE, String.format("[debug mode]sending message success:[%s]", this.request.getMessageId()));
            } else {
                APMCollector.onDiscard((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)this.length);
            }
            APMCollector.onSuccess((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)this.length);
        }

        @Override
        public String getServiceName() {
            return TraceReportServiceImpl.class.getSimpleName();
        }

        @Override
        protected void onWaitEnd() {
        }
    }
}

