/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.transfer;

import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.core.common.ConnectionException;
import com.lubanops.apm.core.common.NamedThreadFactory;
import com.lubanops.apm.core.transfer.InvokerService;
import com.lubanops.apm.integration.access.Address;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.transport.websocket.ConnectConfig;
import com.lubanops.apm.integration.transport.websocket.LubanWebSocketClient;
import com.lubanops.apm.integration.transport.websocket.WebSocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.java_websocket.WebSocketImpl;

public abstract class AbstractInvokerService
implements InvokerService {
    public static final int DEFAULT_CONNECT_INTERVAL = 10;
    private static final Logger LOGGER = LogFactory.getLogger();
    public static final long MAX_CONNECT_TIMEOUT = 10000L;
    public LubanWebSocketClient client = null;
    private final ReentrantLock connectLock = new ReentrantLock();
    private volatile ScheduledExecutorService failBackConnectTimeout = null;
    private volatile boolean closed = false;

    protected LubanWebSocketClient connect(List<Address> addressList, boolean isSecure) {
        return this.connectProxy(addressList, isSecure, null);
    }

    protected LubanWebSocketClient connectProxy(List<Address> addressList, boolean isSecure, String proxyAddr) {
        ConnectConfig newConfig = new ConnectConfig();
        newConfig.setInstanceId(Long.valueOf(IdentityConfigManager.getInstanceId()));
        newConfig.setRandomConnect(false);
        newConfig.setSecure(isSecure);
        newConfig.setConnectTimeout(10000L);
        ArrayList<String> secureList = new ArrayList<String>();
        ArrayList<String> unSecureList = new ArrayList<String>();
        for (Address address : addressList) {
            StringBuilder unSecureUrlBuilder = new StringBuilder(address.getProtocol().getValue());
            unSecureUrlBuilder.append("://").append(address.getHost()).append(":").append(address.getPort());
            unSecureList.add(unSecureUrlBuilder.toString());
            StringBuilder secureUrlBuilder = new StringBuilder(address.getProtocol().getSecure());
            secureUrlBuilder.append("://").append(address.getHost()).append(":").append(address.getSport());
            secureList.add(secureUrlBuilder.toString());
        }
        newConfig.setSecureAddressList(secureList);
        newConfig.setUnSecureAddressList(unSecureList);
        WebSocketFactory factory = WebSocketFactory.getInstance();
        factory.setConfig(newConfig);
        LubanWebSocketClient client = factory.getWebSocketClient(proxyAddr);
        if (!StringUtils.isBlank((String)proxyAddr)) {
            String[] hostAndPort = proxyAddr.split(":");
            InetSocketAddress socksAddr = new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksAddr);
            client.setProxy(proxy);
        }
        return client;
    }

    @Override
    public boolean isSendEnable() {
        if (this.failBackConnectTimeout != null) {
            return false;
        }
        if (this.client != null && this.client.getConnection() != null && !this.client.getConnection().isClosed()) {
            WebSocketImpl webSocketImpl = (WebSocketImpl)this.client.getConnection();
            BlockingQueue queue = webSocketImpl.outQueue;
            if (queue.size() > 100) {
                return false;
            }
        }
        return true;
    }

    public void dispose() throws ApmRuntimeException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.client != null) {
            this.client.close();
        }
        if (null != this.failBackConnectTimeout) {
            this.failBackConnectTimeout.shutdown();
        }
    }

    private LubanWebSocketClient getConnect() throws ConnectionException {
        this.connectLock.lock();
        try {
            if (this.failBackConnectTimeout != null) {
                if (this.client != null && this.client.isOpen()) {
                    this.cancelTimeout();
                    LubanWebSocketClient lubanWebSocketClient = this.client;
                    return lubanWebSocketClient;
                }
                LubanWebSocketClient lubanWebSocketClient = null;
                return lubanWebSocketClient;
            }
            if (this.needReconnect()) {
                if (this.client != null && this.client.isOpen()) {
                    this.client.close();
                }
                this.client = this.createConnectConfig();
                this.cancelTimeout();
            } else if (this.client == null || !this.client.isOpen()) {
                this.client = this.createConnectConfig();
                this.cancelTimeout();
            }
        }
        catch (ConnectionException e) {
            if (this.failBackConnectTimeout == null) {
                this.failBackConnectTimeout = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("APM-getConnectThread", true));
                this.failBackConnectTimeout.scheduleAtFixedRate(new FailBackConnectTimeTask(), 10L, 10L, TimeUnit.SECONDS);
            }
            throw e;
        }
        finally {
            this.connectLock.unlock();
        }
        return this.client;
    }

    protected abstract boolean needReconnect();

    protected abstract LubanWebSocketClient createConnectConfig() throws ConnectionException;

    protected synchronized void sendRequest(MessageWrapper request) throws ConnectionException, IOException {
        LubanWebSocketClient client;
        if (ConfigManager.isValidated() && (client = this.getConnect()) != null && client.getOpenResult()) {
            client.sendAsync(request.generatorMessage());
        }
    }

    private void cancelTimeout() {
        if (null != this.failBackConnectTimeout) {
            this.failBackConnectTimeout.shutdown();
            this.failBackConnectTimeout = null;
        }
    }

    protected final class FailBackConnectTimeTask
    implements Runnable {
        private int retryCount = 0;
        private int circuitCount = 0;

        protected FailBackConnectTimeTask() {
        }

        public FailBackConnectTimeTask reset() {
            FailBackConnectTimeTask newTask = new FailBackConnectTimeTask();
            newTask.setRetryCount(this.retryCount);
            return newTask;
        }

        @Override
        public void run() {
            AbstractInvokerService.this.connectLock.lock();
            try {
                ++this.circuitCount;
                if (this.needRetry()) {
                    AbstractInvokerService.this.client = AbstractInvokerService.this.createConnectConfig();
                    if (AbstractInvokerService.this.client != null) {
                        AbstractInvokerService.this.cancelTimeout();
                    }
                }
            }
            catch (Exception e) {
                ++this.retryCount;
                LOGGER.log(Level.SEVERE, String.format("[APM TRANSFER]reconnect task[%s] has exception.", this), (Throwable)e);
            }
            finally {
                AbstractInvokerService.this.connectLock.unlock();
            }
        }

        private boolean needRetry() {
            if (this.retryCount <= 8) {
                return true;
            }
            int offset = this.circuitCount;
            return this.retryCount - 8 > 4 ? offset % 16 == 0 : offset >= 8 + (int)Math.pow(2.0, this.retryCount - 8);
        }

        public void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }
    }
}

