/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.transformer;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.InterceptorManager;
import com.lubanops.apm.bootstrap.NoneNamedListener;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.core.transformer.CallBack;
import com.lubanops.apm.core.transformer.TransformerManager;
import com.lubanops.apm.core.utils.ClassPoolUtils;
import com.lubanops.apm.core.utils.TransformerUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.MethodInfo;

public class NoneNamedTransformer {
    private static final Logger LOG = LogFactory.getLogger();
    private static Set<String> ignored = new HashSet<String>();
    private URLClassLoader pluginClassLoader;

    public NoneNamedTransformer(URLClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
    }

    public static void interceptorMethods(CtClass cc, List<String> methodPatterns, boolean interceptorGetAndSet, CallBack callBack) throws CannotCompileException, NotFoundException {
        CtMethod[] methods = cc.getDeclaredMethods();
        if (methods == null || methods.length == 0) {
            return;
        }
        ArrayList<CtMethod> allMethodToAddInterceptor = new ArrayList<CtMethod>();
        HashSet<String> getMethods = new HashSet<String>();
        HashSet<String> setMethods = new HashSet<String>();
        HashSet<String> isMethods = new HashSet<String>();
        for (CtMethod ctmethod : methods) {
            String methodname = ctmethod.getName();
            if (!NoneNamedTransformer.ifAddInterceptor(methodPatterns, ctmethod)) continue;
            allMethodToAddInterceptor.add(ctmethod);
            if (interceptorGetAndSet) continue;
            if (methodname.startsWith("get")) {
                getMethods.add(methodname);
                continue;
            }
            if (methodname.startsWith("set")) {
                setMethods.add(methodname);
                continue;
            }
            if (!methodname.startsWith("is")) continue;
            isMethods.add(methodname);
        }
        for (CtMethod ctmethod : allMethodToAddInterceptor) {
            NoneNamedTransformer.interceptorGetAndSet(interceptorGetAndSet, callBack, getMethods, setMethods, isMethods, ctmethod);
        }
    }

    public static boolean ifAddInterceptor(List<String> methodPatterns, CtMethod method) {
        if (method.isEmpty()) {
            return false;
        }
        String methodName = method.getName();
        if (methodName == null || methodName.contains("$")) {
            return false;
        }
        MethodInfo infor = method.getMethodInfo();
        if (infor.isConstructor() || infor.isStaticInitializer()) {
            return false;
        }
        if ((0x40 & infor.getAccessFlags()) != 0) {
            return false;
        }
        int mod = method.getModifiers();
        if (Modifier.isAbstract(mod) || Modifier.isNative(mod)) {
            return false;
        }
        if (ignored.contains(method.getName())) {
            return false;
        }
        if (methodPatterns.size() == 0) {
            return (1 & infor.getAccessFlags()) != 0;
        }
        return methodPatterns.contains(method.getName());
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, List<NoneNamedListener> listenerList) throws IOException, CannotCompileException, NotFoundException {
        if (loader != null && loader.getClass().getName().endsWith("DelegatingClassLoader")) {
            return classfileBuffer;
        }
        for (NoneNamedListener listener : listenerList) {
            ByteArrayInputStream ins;
            List methodPatterns = listener.matchClass(className, classfileBuffer);
            if (methodPatterns == null) continue;
            ClassPool pool = ClassPoolUtils.getClassPool(loader);
            CtClass cc = pool.makeClass((InputStream)(ins = new ByteArrayInputStream(classfileBuffer)));
            if (cc.isInterface() || cc.isAnnotation() || cc.isEnum() || cc.isArray()) {
                return classfileBuffer;
            }
            String interceptorName = listener.getInterceptor();
            String interceptorNameKey = TransformerUtils.interceptorName(loader, interceptorName);
            Interceptor interceptor = null;
            if (listener.appendBootstrapClassLoader()) {
                interceptor = this.getInterceptor(interceptorName, loader);
                interceptorNameKey = interceptorName;
            } else {
                interceptor = this.getInterceptor(interceptorName, loader, interceptorNameKey);
            }
            if (interceptor == null) {
                return classfileBuffer;
            }
            NoneNamedTransformer.interceptorMethods(cc, methodPatterns, false, new InterceptorCallBack(interceptorNameKey, className, pool));
            this.addAttribute(listener, pool, cc, className);
            byte[] bb = cc.toBytecode();
            cc.defrost();
            return bb;
        }
        return classfileBuffer;
    }

    private void addAttribute(NoneNamedListener listener, ClassPool pool, CtClass cc, String className) {
        if (listener.hasAttribute()) {
            try {
                CtClass access = pool.get("com.lubanops.apm.bootstrap.TransformAccess");
                if (!cc.subtypeOf(access)) {
                    cc.addInterface(access);
                    CtField param = new CtField(pool.get("java.lang.Object"), "lopsAttribute", cc);
                    param.setModifiers(2);
                    cc.addField(param);
                    cc.addMethod(CtNewMethod.setter((String)"setLopsAttribute", (CtField)param));
                    cc.addMethod(CtNewMethod.getter((String)"getLopsAttribute", (CtField)param));
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Interceptor failed for " + className, (Throwable)e);
            }
        }
    }

    private Interceptor getInterceptor(String interceptorName, ClassLoader loader, String interceptorNameKey) throws IOException {
        try {
            Interceptor interceptor = InterceptorManager.getInterceptor((String)interceptorNameKey);
            if (interceptor != null) {
                return interceptor;
            }
            Class<?> interceptorClass = null;
            try {
                interceptorClass = loader == null ? Class.forName(interceptorName) : loader.loadClass(interceptorName);
            }
            catch (ClassNotFoundException e) {
                interceptorClass = this.getInterceptorClass(loader, interceptorName);
            }
            if (interceptorClass != null) {
                interceptor = (Interceptor)interceptorClass.newInstance();
                InterceptorManager.setInterceptor((String)interceptorNameKey, (Interceptor)interceptor);
                return interceptor;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "getInterceptor failed" + interceptorName, (Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getInterceptorClass(ClassLoader loader, String interceptorName) throws Exception {
        ZipFile pluginJar = null;
        try {
            Class<?> interceptorClass = null;
            if (loader == null) {
                pluginJar = new JarFile(FileUtils.getInterceptorFile((ClassLoader)this.pluginClassLoader, (String)interceptorName));
                TransformerManager.getInstrumentation().appendToBootstrapClassLoaderSearch((JarFile)pluginJar);
                interceptorClass = Class.forName(interceptorName);
            } else if (loader instanceof URLClassLoader) {
                Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addUrl.setAccessible(true);
                addUrl.invoke((Object)loader, FileUtils.getInterceptorFile((ClassLoader)this.pluginClassLoader, (String)interceptorName).toURI().toURL());
                interceptorClass = loader.loadClass(interceptorName);
            } else {
                File pluginFile = FileUtils.getInterceptorFile((ClassLoader)this.pluginClassLoader, (String)interceptorName);
                pluginJar = new JarFile(pluginFile);
                Enumeration<JarEntry> entry = ((JarFile)pluginJar).entries();
                while (entry.hasMoreElements()) {
                    if (!TransformerUtils.loadFromFile(loader, (JarFile)pluginJar, entry)) continue;
                }
                interceptorClass = loader.loadClass(interceptorName);
            }
            Class<?> clazz = interceptorClass;
            return clazz;
        }
        finally {
            if (pluginJar != null) {
                pluginJar.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Interceptor getInterceptor(String interceptorName, ClassLoader loader) throws IOException {
        ZipFile pluginJar = null;
        try {
            Interceptor interceptor = InterceptorManager.getInterceptor((String)interceptorName);
            if (interceptor != null) {
                Interceptor interceptor2 = interceptor;
                return interceptor2;
            }
            Class<?> interceptorClass = null;
            try {
                interceptorClass = Class.forName(interceptorName);
            }
            catch (ClassNotFoundException e) {
                pluginJar = new JarFile(FileUtils.getInterceptorFile((ClassLoader)this.pluginClassLoader, (String)interceptorName));
                TransformerManager.getInstrumentation().appendToBootstrapClassLoaderSearch((JarFile)pluginJar);
                interceptorClass = Class.forName(interceptorName);
            }
            if (interceptorClass != null) {
                interceptor = (Interceptor)interceptorClass.newInstance();
                InterceptorManager.setInterceptor((String)interceptorName, (Interceptor)interceptor);
                Interceptor interceptor3 = interceptor;
                return interceptor3;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "getInterceptor failed" + interceptorName, (Throwable)ex);
        }
        finally {
            if (pluginJar != null) {
                pluginJar.close();
            }
        }
        return null;
    }

    private static void interceptorGetAndSet(boolean interceptorGetAndSet, CallBack callBack, Set<String> getMethods, Set<String> setMethods, Set<String> isMethods, CtMethod ctmethod) throws CannotCompileException, NotFoundException {
        String methodname = ctmethod.getName();
        if (!interceptorGetAndSet) {
            if (methodname.startsWith("get")) {
                String setname = methodname.replaceFirst("get", "set");
                if (setMethods.contains(setname)) {
                    return;
                }
            } else if (methodname.startsWith("is")) {
                String setname = methodname.replaceFirst("is", "set");
                if (setMethods.contains(setname)) {
                    return;
                }
            } else if (methodname.startsWith("set")) {
                String getname = methodname.replaceFirst("set", "get");
                if (getMethods.contains(getname)) {
                    return;
                }
                String isname = methodname.replaceFirst("set", "is");
                if (isMethods.contains(isname)) {
                    return;
                }
            }
        }
        callBack.interceptor(ctmethod, methodname);
    }

    static {
        ignored.add("getClass");
        ignored.add("hashCode");
        ignored.add("wait");
        ignored.add("equals");
        ignored.add("clone");
        ignored.add("toString");
        ignored.add("toJSONString");
        ignored.add("notify");
        ignored.add("notifyAll");
        ignored.add("finalize");
        ignored.add("main");
    }

    private class InterceptorCallBack
    implements CallBack {
        String interceptorManagerClassName = InterceptorManager.class.getName();
        String interceptorClassName = Interceptor.class.getName();
        private String interceptorName;
        private String className;
        private ClassPool pool;

        public InterceptorCallBack(String interceptorName, String className, ClassPool pool) {
            this.interceptorName = interceptorName;
            this.className = className;
            this.pool = pool;
        }

        @Override
        public void interceptor(CtMethod ctmethod, String methodname) throws CannotCompileException, NotFoundException {
            String thisStr = "$0";
            if ((8 & ctmethod.getMethodInfo().getAccessFlags()) != 0) {
                thisStr = "null";
            }
            this.before(thisStr, methodname, ctmethod);
            StringBuilder catchCode = new StringBuilder();
            catchCode.append("{");
            catchCode.append("try{");
            catchCode.append(this.interceptorClassName).append(" lopsInterceptor = ").append(this.interceptorManagerClassName).append(".getInterceptor(\"").append(this.interceptorName).append("\");");
            catchCode.append("lopsInterceptor.onError(" + thisStr + ",$args,$e,\"").append(this.className).append("\",\"").append(methodname).append("\");");
            catchCode.append("}catch(Throwable e){}");
            catchCode.append("throw $e;");
            catchCode.append("}");
            CtClass ec = this.pool.get("java.lang.Throwable");
            ctmethod.addCatch(catchCode.toString(), ec, "$e");
            StringBuilder afterCode = new StringBuilder();
            afterCode.append("{");
            afterCode.append("try{");
            afterCode.append(this.interceptorClassName).append(" lopsInterceptor = ").append(this.interceptorManagerClassName).append(".getInterceptor(\"").append(this.interceptorName).append("\");");
            afterCode.append("lopsInterceptor.onFinally(" + thisStr + ",$args,($w)$_,\"").append(this.className).append("\",\"").append(methodname).append("\");");
            afterCode.append("}catch(Throwable e){com.lubanops.apm.bootstrap.log.LogFactory.log(e);return $_;}");
            afterCode.append("}");
            ctmethod.insertAfter(afterCode.toString(), true);
        }

        private void before(String thisStr, String methodname, CtMethod ctmethod) throws CannotCompileException {
            StringBuilder beforeCode = new StringBuilder();
            beforeCode.append("{");
            beforeCode.append("try{");
            beforeCode.append(this.interceptorClassName).append(" lopsInterceptor = ").append(this.interceptorManagerClassName).append(".getInterceptor(\"").append(this.interceptorName).append("\");");
            beforeCode.append("lopsInterceptor.onStart(" + thisStr + ",$args,\"").append(this.className).append("\",\"").append(methodname).append("\");");
            beforeCode.append("}catch(Throwable e){com.lubanops.apm.bootstrap.log.LogFactory.log(e);}");
            beforeCode.append("}");
            ctmethod.insertBefore(beforeCode.toString());
        }
    }
}

