/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.utils;

import com.lubanops.apm.bootstrap.collector.api.MetricSet;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.integration.access.inbound.EventDataBody;
import com.lubanops.apm.integration.access.inbound.EventDataHeader;
import com.lubanops.apm.integration.access.inbound.MonitorDataBody;
import com.lubanops.apm.integration.access.inbound.MonitorDataHeader;
import com.lubanops.apm.integration.access.inbound.TxDataHeader;
import com.lubanops.apm.integration.access.trace.MonitorItemRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReportDataBuilder {
    public static EventDataHeader buildEventDataHeader() {
        EventDataHeader header = new EventDataHeader();
        header.setEnvId(IdentityConfigManager.getEnvId());
        header.setInstanceId(IdentityConfigManager.getInstanceId());
        header.setAppId(IdentityConfigManager.getAppId());
        header.setBizId(IdentityConfigManager.getBizId());
        header.setDomainId(IdentityConfigManager.getDomainId());
        header.setAttachment(IdentityConfigManager.getAttachment());
        return header;
    }

    public static MonitorDataHeader buildMonitorDataHeader() {
        MonitorDataHeader header = new MonitorDataHeader();
        header.setEnvId(IdentityConfigManager.getEnvId());
        header.setInstanceId(IdentityConfigManager.getInstanceId());
        header.setAppId(IdentityConfigManager.getAppId());
        header.setBizId(IdentityConfigManager.getBizId());
        header.setDomainId(IdentityConfigManager.getDomainId());
        header.setAttachment(IdentityConfigManager.getAttachment());
        return header;
    }

    public static TxDataHeader buildTxDataHeader() {
        TxDataHeader header = new TxDataHeader();
        header.setEnvId(IdentityConfigManager.getEnvId());
        header.setInstanceId(IdentityConfigManager.getInstanceId());
        header.setAppId(IdentityConfigManager.getAppId());
        header.setBizId(IdentityConfigManager.getBizId());
        header.setDomainId(IdentityConfigManager.getDomainId());
        header.setAttachment(IdentityConfigManager.getAttachment());
        return header;
    }

    public static EventDataBody buildEventDataBody(SpanEvent spanEvent) {
        EventDataBody body = new EventDataBody();
        body.setGlobalTraceId(spanEvent.getGlobalTraceId());
        body.setGlobalPath(spanEvent.getGlobalPath());
        body.setTraceId(spanEvent.getTraceId());
        body.setSpanId(spanEvent.getSpanId());
        body.setEventId(spanEvent.getEventId());
        body.setNextSpanId(spanEvent.getNextSpanId());
        body.setClassName(spanEvent.getClassName());
        body.setMethod(spanEvent.getMethod());
        body.setType(spanEvent.getType());
        body.setStartTime(spanEvent.getStartTime());
        body.setTimeUsed(spanEvent.getTimeUsed());
        body.setChildrenEventCount(spanEvent.getChildrenEventCount());
        body.setHasError(Boolean.valueOf(spanEvent.getHasError()));
        body.setErrorReasons(spanEvent.getErrorReasons());
        body.setSource(spanEvent.getSource());
        body.setRealSource(spanEvent.getRealSource());
        body.setAsync(spanEvent.isAsync());
        body.setTags(spanEvent.getTags());
        body.setCode(Integer.valueOf(spanEvent.getCode()));
        body.setArgument(spanEvent.getArgument());
        body.setSourceEventId(spanEvent.getSourceEventId());
        List discardInfos = spanEvent.getDiscard();
        ArrayList<EventDataBody.DiscardInfo> eventDataDiscardInfos = new ArrayList<EventDataBody.DiscardInfo>();
        for (SpanEvent.DiscardInfo discardInfo : discardInfos) {
            EventDataBody.DiscardInfo eventDataDiscardInfo = new EventDataBody.DiscardInfo();
            eventDataDiscardInfo.setCount(Integer.valueOf(discardInfo.getCount()));
            eventDataDiscardInfo.setTotalTime(Long.valueOf(discardInfo.getTotalTime() / 1000000L));
            eventDataDiscardInfo.setType(discardInfo.getType());
            eventDataDiscardInfos.add(eventDataDiscardInfo);
        }
        body.setDiscard(eventDataDiscardInfos);
        return body;
    }

    public static MonitorDataBody.MetricSetItem buildMetricSetItem(MetricSet metricSet) {
        MonitorDataBody.MetricSetItem monitorItem = new MonitorDataBody.MetricSetItem();
        monitorItem.setCode(metricSet.getCode());
        monitorItem.setName(metricSet.getName());
        monitorItem.setAttachment(metricSet.getAttachment());
        monitorItem.setMsg(metricSet.getMsg());
        ArrayList<MonitorItemRow> itemRows = new ArrayList<MonitorItemRow>();
        List rows = metricSet.getDataRows();
        if (rows != null) {
            for (MonitorDataRow dataRow : metricSet.getDataRows()) {
                itemRows.add(ReportDataBuilder.transferToItemRow(dataRow));
            }
            monitorItem.setDataRows(itemRows);
        }
        return monitorItem;
    }

    private static MonitorItemRow transferToItemRow(MonitorDataRow dataRow) {
        MonitorItemRow itemRow = new MonitorItemRow();
        itemRow.setEntries((Map)dataRow);
        itemRow.setTime(System.currentTimeMillis());
        return itemRow;
    }
}

