/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.huawei.bsp.encrypt.cbb.impl;

import com.lubanops.huawei.bsp.encrypt.cbb.CipherUtil;
import com.lubanops.huawei.bsp.encrypt.cbb.KeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class PBKDF2WithHmacSHA {
    public static final int KEYGEN_ITERATION = 10000;
    public static final int KEYGEN_SALTLEN = 32;
    public static final int KEYGEN_KEYLEN = 256;

    private PBKDF2WithHmacSHA() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Key generateKey(String alg, byte[] keymaterial, byte[] salt, int iteration, int keylen) throws KeyException {
        try {
            byte[] seckeyByte;
            char[] material = CipherUtil.encodeEncryptedText(keymaterial);
            PBEKeySpec keySpec = new PBEKeySpec(material, salt, iteration, keylen);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(alg);
            SecretKey seckey = secretKeyFactory.generateSecret(keySpec);
            keySpec.clearPassword();
            SecretKey secretKey = seckey;
            synchronized (secretKey) {
                seckeyByte = seckey.getEncoded();
            }
            return new SecretKeySpec(seckeyByte, "AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException("no key generate algorithm.");
        }
        catch (InvalidKeySpecException e) {
            throw new KeyException("no pbkdf2 key spec.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] passwordHash(String alg, int iteration, int keylen, char[] material, byte[] salt) throws KeyException {
        try {
            byte[] seckeyByte;
            SecretKey seckey;
            PBEKeySpec keySpec = new PBEKeySpec(material, salt, iteration, keylen);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(alg);
            SecretKey secretKey = seckey = secretKeyFactory.generateSecret(keySpec);
            synchronized (secretKey) {
                seckeyByte = seckey.getEncoded();
            }
            keySpec.clearPassword();
            return seckeyByte;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException("no hash algorithm.");
        }
        catch (InvalidKeySpecException e) {
            throw new KeyException("no pbkdf2 key spec.");
        }
    }
}

