/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.kafka.producer;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaProducerCollector;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;

public class KafkaProducerSendInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (KafkaProducerCollector.INSTANCE.isEnable()) {
            SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"KafkaProducer");
            String topic = null;
            Integer partition = null;
            if (args[0] != null && args[0] instanceof ProducerRecord) {
                ProducerRecord pr = (ProducerRecord)args[0];
                topic = pr.topic();
                partition = pr.partition();
            }
            if (spanEvent != null) {
                String spanId = spanEvent.generateNextSpanId();
                spanEvent.setNextSpanId(null);
                String traceId = spanEvent.getTraceId();
                String gTraceId = TraceCollector.getVirtualTraceId();
                if (topic != null) {
                    spanEvent.addTag("topic", topic);
                }
                if (partition != null) {
                    spanEvent.addTag("partition", String.valueOf(partition));
                }
                try {
                    if (args[0] instanceof ProducerRecord && this.getVersion(object) >= 2) {
                        Headers headers = ((ProducerRecord)args[0]).headers();
                        headers.add(com.lubanops.apm.bootstrap.trace.Headers.TRACE_ID.getValue(), traceId.getBytes("UTF-8"));
                        headers.add(com.lubanops.apm.bootstrap.trace.Headers.SPAN_ID.getValue(), spanId.getBytes("UTF-8"));
                        headers.add(com.lubanops.apm.bootstrap.trace.Headers.GTRACE_ID.getValue(), gTraceId.getBytes("UTF-8"));
                        spanEvent.addTag("nextTrace", gTraceId + "|" + traceId + "|" + spanId);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (topic != null) {
                KafkaProducerCollector.onStart(topic);
            }
        }
        return null;
    }

    private byte getVersion(Object object) {
        Object newVersion;
        Object[] fileds;
        if (object instanceof AttributeAccess && (fileds = ((AttributeAccess)object).getLopsFileds()).length > 1 && fileds[1] != null && fileds[1] instanceof ApiVersions && fileds[1] instanceof TransformAccess && (newVersion = ((TransformAccess)fileds[1]).getLopsAttribute()) != null && newVersion instanceof Byte) {
            return (Byte)newVersion;
        }
        return 1;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (KafkaProducerCollector.INSTANCE.isEnable()) {
            TraceCollector.onError((Throwable)e);
            String topic = null;
            if (args[0] != null && args[0] instanceof ProducerRecord) {
                ProducerRecord pr = (ProducerRecord)args[0];
                topic = pr.topic();
            }
            if (topic != null) {
                KafkaProducerCollector.onThrowable(topic, (Throwable)e);
            }
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (KafkaProducerCollector.INSTANCE.isEnable()) {
            TraceCollector.onFinally();
            String topic = null;
            if (args[0] != null && args[0] instanceof ProducerRecord) {
                ProducerRecord pr = (ProducerRecord)args[0];
                topic = pr.topic();
            }
            if (topic != null) {
                KafkaProducerCollector.onFinally(topic);
            }
        }
    }
}

