/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.collector;

import com.lubanops.apm.bootstrap.collector.MonitorItem;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CollectorManager {
    private static final ConcurrentMap<String, Collector> COLLECTOR_MAP = new ConcurrentHashMap<String, Collector>();
    private static ConcurrentMap<String, MonitorItem> monitorItemMap = new ConcurrentHashMap<String, MonitorItem>();
    public static final List<String> TAGS = new ArrayList<String>();

    public static void setMonitorItemList(List<MonitorItem> list) {
        ConcurrentHashMap<String, MonitorItem> newMap = new ConcurrentHashMap<String, MonitorItem>(64);
        for (MonitorItem monitorItem : list) {
            newMap.put(monitorItem.getCollectorName(), monitorItem);
        }
        CollectorManager.setMonitorItemMap(newMap);
        CollectorManager.syncStatus();
    }

    public static void register(Collector collector) {
        if (StringUtils.isBlank(collector.getCollectorName())) {
            return;
        }
        if (CollectorManager.getMonitorItemMap().containsKey(collector.getCollectorName())) {
            MonitorItem monitorItem = (MonitorItem)CollectorManager.getMonitorItemMap().get(collector.getCollectorName());
            if (monitorItem != null && monitorItem.getStatus() == 0) {
                collector.setParameters(monitorItem.getParameters(), collector.getCollectorName());
                collector.setEnable(true);
            } else {
                collector.setEnable(false);
            }
        }
        COLLECTOR_MAP.put(collector.getCollectorName(), collector);
    }

    public static void addTag(String tag) {
        if (!TAGS.contains(tag)) {
            TAGS.add(tag);
        }
    }

    public static Collection<Collector> getAllCollectors() {
        return COLLECTOR_MAP.values();
    }

    public static Collector getCollector(String name) {
        return (Collector)COLLECTOR_MAP.get(name);
    }

    public static Map<String, Collector> newCopyOfCollectors() {
        return new HashMap<String, Collector>(COLLECTOR_MAP);
    }

    private static void syncStatus() {
        for (Collector collector : COLLECTOR_MAP.values()) {
            MonitorItem monitorItem = (MonitorItem)CollectorManager.getMonitorItemMap().get(collector.getCollectorName());
            if (monitorItem != null && monitorItem.getStatus() == 0) {
                collector.setParameters(monitorItem.getParameters(), collector.getCollectorName());
                collector.setEnable(true);
                continue;
            }
            collector.setEnable(false);
        }
    }

    public static ConcurrentMap<String, MonitorItem> getMonitorItemMap() {
        return monitorItemMap;
    }

    public static void setMonitorItemMap(ConcurrentMap<String, MonitorItem> monitorItemMap) {
        CollectorManager.monitorItemMap = monitorItemMap;
    }
}

