/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.config;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.bootstrap.utils.ParamCheckUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class AgentConfigManager {
    private static final int DEFAULT_BODY_LENGTH = 9999;
    public static final String MASTER_ADDRESS = "master.address";
    public static final String MASTER_ADDRESS_SYS_KEY = "masterAddress";
    public static final String MASTER_ADDRESS_ENV_KEY = "APM_MASTER_ADDRESS";
    public static final String TX_ENABLE = "transaction.enable";
    public static final String ACCESS_ADDRESS_SYS_KEY = "accessAddress";
    public static final String ACCESS_ADDRESS_ENV_KEY = "APM_ACCESS_ADDRESS";
    public static final String ACCESS_ADDRESS = "access.address";
    public static final String SECURE_CHANNEL = "access.secure.channel";
    public static final String LOG_LEVEL = "log.level";
    public static final String EVENT_THREAD_COUNT = "event.thread.count";
    public static final String MASTER_ACCESS_KEY = "access.key";
    public static final String MASTER_ACCESS_KEY_SYS_KEY = "accessKey";
    public static final String MASTER_ACCESS_KEY_ENV_KEY = "APM_ACCESS_KEY";
    public static final String MASTER_SECRET_KEY = "secret.key";
    public static final String MASTER_SECRET_KEY_SYS_KEY = "secretKey";
    public static final String MASTER_SECRET_KEY_ENV_KEY = "APM_SECRET_KEY";
    public static final String FILTER_LOG_MESSAGE = "filter.log.message";
    public static final String RUN_ENVIRONMENT = "run_environment";
    public static final String PROXY = "apm.proxy";
    public static final String SYS_PROXY_LIST = "apmProxy";
    public static final String ENV_PROXY_LIST = "APM_PROXY_LIST";
    public static final String COLLECT_BODY = "collect.body";
    public static final String COLLECT_METHOD_BODY = "collect.method.body";
    public static final String COLLECT_HTTPCLIENT_BODY = "collect.httpclient.body";
    public static final String COLLECT_SQL_RESULT = "collect.sql.result";
    public static final String COLLECT_BODY_LENGTH = "collect.body.length";
    public static final String DECRYPT_CLASS_NAME = "decrypt.className";
    public static final String DECRYPT_METHOD_NAME = "decrypt.methodName";
    private static final String DECRYPT_PACKAGE = "ext";
    private static boolean isClosed = false;
    private static String masterAddress = "";
    private static String accessAddress = "";
    private static boolean isServerLess = false;
    private static String logLevel = "info";
    private static int eventThreadCount = 3;
    private static boolean txEnable = true;
    private static Boolean secureChannel = null;
    private static String[] proxyList = new String[0];
    private static String masterAuthAk;
    private static String masterAuthSk;
    private static boolean collectBody;
    private static boolean collectSQLResult;
    private static boolean collectMethodBody;
    private static boolean collectHttpClientBody;
    private static boolean isKunPeng;
    private static int collectBodyLength;
    private static final Logger LOGGER;
    private static boolean filterLogMessage;

    public static void init(String configPath) {
        String isSecureChannel;
        String txEnable;
        Properties properties = FileUtils.readFilePropertyByPath(configPath + File.separator + "apm.config");
        AgentConfigManager.parseMasterAuthAk(properties);
        AgentConfigManager.parseMasterAuthSk(properties);
        AgentConfigManager.parseProxyList(properties);
        AgentConfigManager.parseAccessAddress(properties);
        AgentConfigManager.getDecryptSK(configPath, properties);
        AgentConfigManager.parseMasterAddress(properties);
        AgentConfigManager.setLogLevel(properties.getProperty(LOG_LEVEL));
        AgentConfigManager.setEventThreadCount(StringUtils.string2Int(properties.getProperty(EVENT_THREAD_COUNT), 3));
        String filterLogMessage = properties.getProperty(FILTER_LOG_MESSAGE);
        if ("true".equals(filterLogMessage)) {
            AgentConfigManager.filterLogMessage = true;
        }
        if ("true".equals(txEnable = properties.getProperty(TX_ENABLE))) {
            AgentConfigManager.txEnable = true;
        }
        if ("true".equals(isSecureChannel = properties.getProperty(SECURE_CHANNEL))) {
            secureChannel = true;
        } else if ("false".equals(isSecureChannel)) {
            secureChannel = false;
        }
        AgentConfigManager.checkAgentConfig();
        AgentConfigManager.getBodyConfig(properties);
    }

    private static void parseMasterAddress(Properties properties) {
        if (StringUtils.isBlank(masterAddress)) {
            masterAddress = System.getProperty(MASTER_ADDRESS_SYS_KEY);
        }
        if (StringUtils.isBlank(masterAddress)) {
            masterAddress = System.getenv(MASTER_ADDRESS_ENV_KEY);
        }
        if (StringUtils.isBlank(masterAddress)) {
            masterAddress = properties.getProperty(MASTER_ADDRESS);
        }
    }

    private static void parseAccessAddress(Properties properties) {
        if (StringUtils.isBlank(accessAddress)) {
            accessAddress = System.getProperty(ACCESS_ADDRESS_SYS_KEY);
        }
        if (StringUtils.isBlank(accessAddress)) {
            accessAddress = System.getenv(ACCESS_ADDRESS_ENV_KEY);
        }
        if (StringUtils.isBlank(accessAddress)) {
            accessAddress = properties.getProperty(ACCESS_ADDRESS);
        }
    }

    private static void parseProxyList(Properties properties) {
        if (proxyList.length > 0) {
            return;
        }
        String proxyString = System.getProperty(SYS_PROXY_LIST);
        if (StringUtils.isBlank(proxyString)) {
            proxyString = System.getenv(ENV_PROXY_LIST);
        }
        if (StringUtils.isBlank(proxyString)) {
            proxyString = properties.getProperty(PROXY);
        }
        if (!StringUtils.isBlank(proxyString)) {
            proxyList = proxyString.trim().split(",");
        }
    }

    private static void parseMasterAuthSk(Properties properties) {
        if (StringUtils.isBlank(masterAuthSk)) {
            masterAuthSk = System.getProperty(MASTER_SECRET_KEY_SYS_KEY);
        }
        if (StringUtils.isBlank(masterAuthSk)) {
            masterAuthSk = System.getenv(MASTER_SECRET_KEY_ENV_KEY);
        }
        if (StringUtils.isBlank(masterAuthSk)) {
            masterAuthSk = properties.getProperty(MASTER_SECRET_KEY);
        }
    }

    private static void parseMasterAuthAk(Properties properties) {
        if (StringUtils.isBlank(masterAuthAk)) {
            masterAuthAk = System.getProperty(MASTER_ACCESS_KEY_SYS_KEY);
        }
        if (StringUtils.isBlank(masterAuthAk)) {
            masterAuthAk = System.getenv(MASTER_ACCESS_KEY_ENV_KEY);
        }
        if (StringUtils.isBlank(masterAuthAk)) {
            masterAuthAk = properties.getProperty(MASTER_ACCESS_KEY);
        }
    }

    private static void getDecryptSK(String configPath, Properties properties) {
        String decryptClassName = properties.getProperty(DECRYPT_CLASS_NAME);
        String decryptMethodName = properties.getProperty(DECRYPT_METHOD_NAME);
        if (!StringUtils.isBlank(decryptClassName) && !StringUtils.isBlank(decryptMethodName)) {
            String encryptUrl = configPath + File.separator + DECRYPT_PACKAGE;
            final List<URL> libUrls = FileUtils.getLibUrl(encryptUrl);
            URLClassLoader pluginClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new URLClassLoader(libUrls.toArray(new URL[libUrls.size()]), ClassLoader.getSystemClassLoader());
                }
            });
            try {
                LOGGER.log(Level.INFO, "start decrypt user sk .");
                Class<?> encryptClass = pluginClassLoader.loadClass(decryptClassName);
                Method declaredMethod = encryptClass.getDeclaredMethod(decryptMethodName, String.class);
                String decryptSK = (String)declaredMethod.invoke(encryptClass, masterAuthSk);
                LOGGER.log(Level.INFO, "decrypt user sk end .");
                if (!StringUtils.isBlank(decryptSK)) {
                    masterAuthSk = decryptSK;
                }
                pluginClassLoader.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "[APM CONFIG]masterAuthSk decrypt failed.", e);
            }
        }
        if (!StringUtils.isBlank(masterAuthSk) && masterAuthSk.startsWith("E(")) {
            AgentConfigManager.decryptAPMSK(configPath);
        }
        if (!StringUtils.isBlank(masterAuthSk) && masterAuthSk.startsWith("C[")) {
            AgentConfigManager.decryptCSESK();
        }
    }

    private static void decryptAPMSK(String configPath) {
        String sk = masterAuthSk.substring(2, masterAuthSk.length() - 1);
        String keyStr = FileUtils.readFile(configPath + File.separator + ".apmk").trim();
        String ivStr = FileUtils.readFile(configPath + File.separator + ".apmi").trim();
        String result = APIService.getDecryptAPI().decrypt(sk, keyStr, ivStr);
        if (!StringUtils.isBlank(result)) {
            masterAuthSk = result.trim();
        }
    }

    private static void decryptCSESK() {
        String decryptSK = masterAuthSk.substring(2, masterAuthSk.length() - 1);
        decryptSK = APIService.getDecryptAPI().decryptCSESK(decryptSK);
        if (!StringUtils.isBlank(decryptSK)) {
            masterAuthSk = decryptSK;
        }
    }

    private static void getBodyConfig(Properties properties) {
        String collectSQLResultStr;
        String collectBodyStr = properties.getProperty(COLLECT_BODY);
        collectBody = "true".equals(collectBodyStr);
        String collectMethodBodyStr = properties.getProperty(COLLECT_METHOD_BODY);
        collectMethodBody = "true".equals(collectMethodBodyStr);
        String collectHttpClientBodyStr = properties.getProperty(COLLECT_HTTPCLIENT_BODY);
        collectHttpClientBody = "true".equals(collectHttpClientBodyStr);
        String collectBodyLengthStr = properties.getProperty(COLLECT_BODY_LENGTH);
        if (collectBodyLengthStr != null) {
            try {
                collectBodyLength = Integer.valueOf(collectBodyLengthStr);
            }
            catch (NumberFormatException e) {
                collectBodyLength = 9999;
            }
        } else {
            collectBodyLength = 9999;
        }
        collectSQLResult = "true".equals(collectSQLResultStr = properties.getProperty(COLLECT_SQL_RESULT));
    }

    private static void checkAgentConfig() {
        if (!ParamCheckUtils.isUrl(masterAddress)) {
            throw new IllegalArgumentException(String.format("[AGENT CONFIG]master address[%s] illegal.", masterAddress));
        }
        if (AgentConfigManager.getProxyList() != null && AgentConfigManager.getProxyList().length > 10) {
            throw new IllegalArgumentException(String.format("[AGENT CONFIG]proxy list[%s] illegal.", AgentConfigManager.getProxyList() == null ? "" : Arrays.asList(AgentConfigManager.getProxyList()).toString()));
        }
    }

    public static String getMasterAddress() {
        return masterAddress;
    }

    public static void setMasterAddress(String masterAddress) {
        AgentConfigManager.masterAddress = masterAddress;
    }

    public static boolean isFilterLogMessage() {
        return filterLogMessage;
    }

    public static void setFilterLogMessage(boolean filterLogMessage) {
        AgentConfigManager.filterLogMessage = filterLogMessage;
    }

    public static String getMasterAuthAk() {
        return masterAuthAk;
    }

    public static void setMasterAuthAk(String masterAuthAk) {
        AgentConfigManager.masterAuthAk = masterAuthAk;
    }

    public static String getMasterAuthSk() {
        return masterAuthSk;
    }

    public static void setMasterAuthSk(String masterAuthSk) {
        AgentConfigManager.masterAuthSk = masterAuthSk;
    }

    public static String[] getProxyList() {
        return (String[])proxyList.clone();
    }

    public static void setProxyList(String[] proxyList) {
        AgentConfigManager.proxyList = (String[])proxyList.clone();
    }

    public static String getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(String logLevel) {
        Level level = AgentConfigManager.getLevel(logLevel);
        Logger logger = LogFactory.getLogger();
        if (logger != null) {
            logger.setLevel(level);
        }
        AgentConfigManager.logLevel = logLevel;
    }

    public static int getEventThreadCount() {
        return eventThreadCount;
    }

    public static void setEventThreadCount(int eventThreadCount) {
        AgentConfigManager.eventThreadCount = eventThreadCount;
    }

    public static Level getLevel(String levelStr) {
        if (levelStr != null) {
            if ("error".equals(levelStr.toLowerCase())) {
                return Level.SEVERE;
            }
            if ("debug".equals(levelStr.toLowerCase())) {
                return Level.FINE;
            }
        }
        return Level.INFO;
    }

    public static String getAccessAddress() {
        return accessAddress;
    }

    public static boolean isCollectBody() {
        if (!isKunPeng) {
            return false;
        }
        return collectBody;
    }

    public static boolean isCollectSQLResult() {
        if (!isKunPeng) {
            return false;
        }
        return collectSQLResult;
    }

    public static void setCollectBody(boolean collectBody) {
        AgentConfigManager.collectBody = collectBody;
    }

    public static boolean isCollectMethodBody() {
        if (!isKunPeng) {
            return false;
        }
        return collectMethodBody;
    }

    public static boolean isCollectHttpClientBody() {
        if (!isKunPeng) {
            return false;
        }
        return collectHttpClientBody;
    }

    public static void setCollectMethodBody(boolean collectMethodBody) {
        AgentConfigManager.collectMethodBody = collectMethodBody;
    }

    public static int getCollectBodyLength() {
        return collectBodyLength;
    }

    public static void setCollectBodyLength(int collectBodyLength) {
        AgentConfigManager.collectBodyLength = collectBodyLength;
    }

    public static boolean isServerLess() {
        return isServerLess;
    }

    public static void setServerLess(boolean isServerLess) {
        AgentConfigManager.isServerLess = isServerLess;
    }

    public static boolean isTxEnable() {
        return txEnable;
    }

    public static void setTxEnable(boolean txEnable) {
        AgentConfigManager.txEnable = txEnable;
    }

    public static Boolean isSecureChannel() {
        return secureChannel;
    }

    public static void setSecureChannel(Boolean secureChannel) {
        AgentConfigManager.secureChannel = secureChannel;
    }

    public static boolean isClosed() {
        return isClosed;
    }

    public static void setClosed(boolean isClosed) {
        AgentConfigManager.isClosed = isClosed;
    }

    static {
        collectBody = false;
        collectSQLResult = false;
        collectMethodBody = false;
        collectHttpClientBody = false;
        isKunPeng = false;
        collectBodyLength = 9999;
        LOGGER = LogFactory.getLogger();
        filterLogMessage = false;
    }
}

