/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.log;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogEvent;
import com.lubanops.apm.bootstrap.log.LoggerThread;
import java.util.Date;

public class Logger {
    private Level logLevel = Level.INFO;
    private int count = 0;

    public boolean log(Level level, String msg, Throwable e) {
        if (this.isLoggable(level)) {
            return LoggerThread.logQueue.offer(new LogEvent(msg, level, e, new Date()));
        }
        return false;
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg, null);
    }

    public void warningFullQueue(String msg) {
        ++this.count;
        if (this.count > 50) {
            return;
        }
        this.log(Level.WARNING, msg, null);
    }

    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg, null);
    }

    public boolean isLoggable(Level level) {
        return this.logLevel.getValue() <= level.getValue();
    }

    public void setLevel(Level newLevel) {
        this.logLevel = newLevel;
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg, null);
    }
}

