/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.trace;

import com.lubanops.apm.bootstrap.agent.AgentInfo;
import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.trace.ErrorType;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceReportService;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TraceCollector {
    private static final int MAX_SPAN_EVENT_COUNT = 200;
    public static final ThreadLocal<String> G_TRACE_ID_THREAD_LOCAL = new ThreadLocal();
    public static final ThreadLocal<String> USER_FLAG_THREAD_LOCAL = new ThreadLocal();
    public static final ThreadLocal<SpanEvent.DiscardInfo> DISCARD_INFO = new ThreadLocal();
    public static final ThreadLocal<Boolean> EXCEPTION_LOCAL = new ThreadLocal();
    private static ThreadLocal<SpanEvent> threadLocal = new ThreadLocal();
    private static final Logger LOGGER = LogFactory.getLogger();
    private static TraceReportService traceReportService;

    public static SpanEvent onStart(StartTraceRequest startTraceRequest) {
        TraceCollector.filterSpanId(startTraceRequest);
        if (startTraceRequest.getSampleFilter() == null || TraceCollector.hasTraceId(startTraceRequest) || startTraceRequest.getSampleFilter().sample(startTraceRequest.getSource(), startTraceRequest.getHttpMethod())) {
            List<String> txName;
            long startTime = System.currentTimeMillis();
            long nanoTime = System.nanoTime();
            SpanEvent spanEvent = new SpanEvent(startTraceRequest.getTraceId(), startTraceRequest.getSpanId(), startTraceRequest.getDomainId());
            spanEvent.setStartTime(startTime);
            spanEvent.setType(startTraceRequest.getKind());
            spanEvent.setThreadId(Thread.currentThread().getId());
            spanEvent.setClassName(startTraceRequest.getTraceClass());
            spanEvent.setMethod(startTraceRequest.getMethod());
            spanEvent.setSource(startTraceRequest.getSource());
            spanEvent.setRealSource(startTraceRequest.getRealSource());
            spanEvent.setStartNanoTime(nanoTime);
            spanEvent.setSourceEventId(startTraceRequest.getSourceEventId());
            spanEvent.setGlobalTraceId(TraceCollector.setGtraceId(startTraceRequest, spanEvent));
            if (startTraceRequest.getHttpMethod() != null) {
                spanEvent.addTag("httpMethod", startTraceRequest.getHttpMethod());
            }
            if ((txName = TransactionCollector.getTxName()) != null && txName.size() > 0) {
                spanEvent.addTag("transactionNames", txName.toString());
            }
            threadLocal.set(spanEvent);
            return spanEvent;
        }
        TraceCollector.setGtraceId(startTraceRequest, null);
        return null;
    }

    public static void filterSpanId(StartTraceRequest startTraceRequest) {
        String spanId = startTraceRequest.getSpanId();
        if (spanId != null && spanId.length() > 100) {
            startTraceRequest.setTraceId(null);
            startTraceRequest.setSpanId(null);
        }
    }

    public static boolean hasTraceId(StartTraceRequest startTraceRequest) {
        return TraceCollector.isSameDomain(startTraceRequest) && !StringUtils.isBlank(startTraceRequest.getTraceId());
    }

    public static boolean isSameDomain(StartTraceRequest startTraceRequest) {
        String fromDomainId = startTraceRequest.getDomainId();
        String fromDomainType = startTraceRequest.getDomainType();
        return TraceCollector.isSameDomain(fromDomainId, fromDomainType);
    }

    public static boolean isSameDomain(String fromDomainId, String fromDomainType) {
        String toDomainId = String.valueOf(IdentityConfigManager.getDomainId());
        String toDomainType = IdentityConfigManager.getDomainType();
        if (!(StringUtils.isBlank(fromDomainType) || StringUtils.isBlank(toDomainType) || fromDomainType.equals(toDomainType))) {
            return false;
        }
        return StringUtils.isBlank(fromDomainId) || toDomainId.equals(fromDomainId);
    }

    public static String setGtraceId(StartTraceRequest startTraceRequest, SpanEvent spanEvent) {
        String globalTraceId = null;
        globalTraceId = !StringUtils.isBlank(startTraceRequest.getgTraceId()) && TraceCollector.isSameDomain(startTraceRequest) ? startTraceRequest.getgTraceId() : (spanEvent == null ? AgentInfo.generateVirtualTraceId() : spanEvent.getTraceId());
        G_TRACE_ID_THREAD_LOCAL.set(globalTraceId);
        return globalTraceId;
    }

    public static SpanEvent onStart(String className, String method, String kind) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long nanoTime = System.nanoTime();
            if (spanEvent.getChildSpanEventCount() < 200) {
                long startTime = System.currentTimeMillis();
                SpanEvent newSpanEvent = new SpanEvent(spanEvent);
                if (newSpanEvent.getEventId().length() > 200) {
                    LOGGER.log(Level.SEVERE, "spanEventId is too long" + APIService.getJsonApi().toJSONString(spanEvent));
                    threadLocal.set(null);
                    return null;
                }
                newSpanEvent.setStartTime(startTime);
                newSpanEvent.setStartNanoTime(nanoTime);
                newSpanEvent.setClassName(className);
                newSpanEvent.setMethod(method);
                newSpanEvent.setType(kind);
                threadLocal.set(newSpanEvent);
                return newSpanEvent;
            }
            if (spanEvent.getDisableDeep() == 0) {
                Map<String, SpanEvent.DiscardInfo> map = spanEvent.getDiscardMap();
                SpanEvent.DiscardInfo discardInfo = map.get(kind);
                if (discardInfo == null) {
                    discardInfo = new SpanEvent.DiscardInfo();
                    map.put(kind, discardInfo);
                }
                discardInfo.setType(kind);
                spanEvent.setDiscardSpanEventStartTime(nanoTime);
                DISCARD_INFO.set(discardInfo);
            }
            spanEvent.addDisableDeep();
            return null;
        }
        return spanEvent;
    }

    public static SpanEvent onError(Throwable e) {
        return TraceCollector.onError(threadLocal.get(), e);
    }

    public static SpanEvent onError(SpanEvent spanEvent, Throwable e) {
        if (spanEvent != null && e != null) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            spanEvent.addTag("exceptionType", e.getClass().getName());
            spanEvent.addTag("exceptionMsg", e.getMessage(), 10000);
            spanEvent.setSpanError(true);
            spanEvent.setErrorReasons(ErrorType.EXCEPTION_ERR.name());
        }
        return spanEvent;
    }

    public static SpanEvent onFinally(boolean send) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long endTime = System.nanoTime();
            if (spanEvent.getDisableDeep() == 0) {
                if (spanEvent.getParent() == null) {
                    return null;
                }
                long timeUsed = endTime - spanEvent.getStartNanoTime();
                spanEvent.setTimeUsed(timeUsed);
                threadLocal.set(spanEvent.getParent());
                spanEvent.setDiscardInfo();
                if (send) {
                    TraceCollector.sendSpanEvent(spanEvent);
                }
            } else {
                TraceCollector.saveDiscardInfo(spanEvent, endTime);
                return null;
            }
        }
        return spanEvent;
    }

    private static void saveDiscardInfo(SpanEvent spanEvent, long endTime) {
        SpanEvent.DiscardInfo discardInfo;
        spanEvent.subDisableDeep();
        if (spanEvent.getDisableDeep() == 0 && (discardInfo = DISCARD_INFO.get()) != null) {
            DISCARD_INFO.set(null);
            if (spanEvent.getDiscardSpanEventStartTime() > 0L) {
                long timeUsed = endTime - spanEvent.getDiscardSpanEventStartTime();
                spanEvent.setDiscardSpanEventStartTime(0L);
                discardInfo.setCount(discardInfo.getCount() + 1);
                discardInfo.setTotalTime(discardInfo.getTotalTime() + timeUsed);
            }
        }
    }

    public static SpanEvent onFinally() {
        return TraceCollector.onFinally(true);
    }

    public static SpanEvent onFinally(int code, boolean isError) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long endTime = System.nanoTime();
            long timeUsed = endTime - spanEvent.getStartNanoTime();
            spanEvent.setTimeUsed(timeUsed);
            spanEvent.setCode(code);
            if (isError) {
                spanEvent.setSpanError(isError);
                spanEvent.setErrorReasons(ErrorType.CODE_ERR.name());
            }
            threadLocal.set(null);
            spanEvent.setDiscardInfo();
            spanEvent.setThreadId(null);
            TraceCollector.sendSpanEvent(spanEvent);
        }
        G_TRACE_ID_THREAD_LOCAL.set(null);
        USER_FLAG_THREAD_LOCAL.set(null);
        return spanEvent;
    }

    public static SpanEvent onRootFinallyNoSend() {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long endTime = System.nanoTime();
            long timeUsed = endTime - spanEvent.getStartNanoTime();
            spanEvent.setTimeUsed(timeUsed);
            threadLocal.set(null);
            spanEvent.setDiscardInfo();
        }
        G_TRACE_ID_THREAD_LOCAL.set(null);
        USER_FLAG_THREAD_LOCAL.set(null);
        return spanEvent;
    }

    public static SpanEvent onFinally(int code) {
        return TraceCollector.onFinally(code, false);
    }

    public static void sendSpanEvent(SpanEvent spanEvent) {
        if (spanEvent == null) {
            LOGGER.log(Level.SEVERE, "[Trace Collector]push span event error,NOP event.");
            return;
        }
        traceReportService.offerEvent(spanEvent);
    }

    public static void onFinallySpanEvent(SpanEvent spanEvent) {
        long endTime = System.nanoTime();
        long timeUsed = endTime - spanEvent.getStartNanoTime();
        spanEvent.setTimeUsed(timeUsed);
        traceReportService.offerEvent(spanEvent);
    }

    public static SpanEvent onFinallySpanEvent(int code, boolean isError, SpanEvent spanEvent) {
        if (spanEvent != null) {
            long endTime = System.nanoTime();
            long timeUsed = endTime - spanEvent.getStartNanoTime();
            spanEvent.setTimeUsed(timeUsed);
            spanEvent.setCode(code);
            if (isError) {
                spanEvent.setSpanError(isError);
                spanEvent.setErrorReasons(ErrorType.CODE_ERR.name());
            }
            spanEvent.setDiscardInfo();
            spanEvent.setThreadId(null);
            TraceCollector.sendSpanEvent(spanEvent);
        }
        return spanEvent;
    }

    public static void clear() {
        threadLocal.set(null);
        G_TRACE_ID_THREAD_LOCAL.set(null);
        USER_FLAG_THREAD_LOCAL.set(null);
    }

    public static SpanEvent getSpanEvent() {
        SpanEvent spanevent = threadLocal.get();
        if (spanevent == null || spanevent.getDisableDeep() > 0) {
            return null;
        }
        return spanevent;
    }

    public static void setSpanEvent(SpanEvent spanEvent) {
        threadLocal.set(spanEvent);
    }

    public static String getTraceId() {
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        return spanEvent == null ? null : spanEvent.getTraceId();
    }

    public static String getVirtualTraceId() {
        return G_TRACE_ID_THREAD_LOCAL.get();
    }

    public static String getUserFlag() {
        return USER_FLAG_THREAD_LOCAL.get();
    }

    public static void addTag(String key, String value) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null && spanEvent.getDisableDeep() == 0) {
            spanEvent.addTag(key, value);
        }
    }

    public static void addTag(String key, String value, int limit) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null && spanEvent.getDisableDeep() == 0) {
            spanEvent.addTag(key, value, limit);
        }
    }

    public static Map<String, Object> getTraceMapByCseContext(String cseContext) {
        if (cseContext != null) {
            try {
                HashMap map = APIService.getJsonApi().parseObject(cseContext, HashMap.class);
                return map;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCseMapValue(Map map, String key) {
        if (map == null) {
            return null;
        }
        Object value = map.get(key);
        return value == null ? null : String.valueOf(value);
    }

    public static void setReportService(TraceReportService traceReportService) {
        TraceCollector.traceReportService = traceReportService;
    }

    public static Boolean hasException() {
        Boolean hasException = EXCEPTION_LOCAL.get();
        if (hasException == null) {
            return false;
        }
        EXCEPTION_LOCAL.set(null);
        return hasException;
    }

    public static void setException(Boolean hasException) {
        EXCEPTION_LOCAL.set(hasException);
    }
}

