/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.collector;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.cassandra3.SessionHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class CassandraConfigAggregator
extends AbstractAggregator {
    public List<MonitorDataRow> harvest() {
        return this.getAllStatus();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public String getName() {
        return "config";
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        Integer sessionId;
        String sessionIdStr = primaryKeyMap.get("sessionId");
        try {
            sessionId = Integer.parseInt(sessionIdStr);
        }
        catch (Exception e) {
            return null;
        }
        CopyOnWriteArrayList<Object> sessionList = SessionHolder.getSessionList();
        for (Object o : sessionList) {
            MonitorDataRow row = this.buildRow(o);
            if (row == null || !sessionId.equals(row.get((Object)"sessionId"))) continue;
            return row;
        }
        return null;
    }

    private MonitorDataRow buildRow(Object session) {
        Integer sessionId = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)session, (String)"sessionId");
        if (sessionId == null) {
            return null;
        }
        if (session instanceof TransformAccess) {
            MonitorDataRow row = new MonitorDataRow();
            Cluster cluster = (Cluster)((AttributeAccess)session).getLopsFileds()[0];
            String hosts = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)session, (String)"hosts");
            Configuration configuration = cluster.getConfiguration();
            row.add("sessionId", (Object)sessionId);
            row.add("hosts", (Object)hosts);
            return row;
        }
        return null;
    }

    public void clear() {
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        CopyOnWriteArrayList<Object> sessionList = SessionHolder.getSessionList();
        for (Object session : sessionList) {
            MonitorDataRow row = this.buildRow(session);
            if (row == null) continue;
            result.add(row);
        }
        return result;
    }

    public void parseParameters(Map<String, String> parameters) {
    }
}

