/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.plugin.cassandra3.apreload.CassandraStats;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CassandraNodeAggregator
extends SinglePrimaryKeyAggregator<CassandraStats> {
    public void parseParameters(Map<String, String> parameters) {
    }

    public Map<String, Object> onStartAsync(String node) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.isEnable) {
            return map;
        }
        CassandraStats stats = (CassandraStats)this.getValue(node);
        if (stats != null) {
            map.put("startTime", stats.onStart());
            map.put("stats", (Object)stats);
        }
        return map;
    }

    public Map<String, Object> onErrorAsync(Map<String, Object> context, String traceId) {
        if (!this.isEnable) {
            return context;
        }
        CassandraStats stats = (CassandraStats)((Object)context.get("stats"));
        if (stats != null) {
            stats.onError(traceId);
        }
        return context;
    }

    public void onFinallyAsync(Map<String, Object> context, String traceId) {
        if (!this.isEnable) {
            return;
        }
        CassandraStats stats = (CassandraStats)((Object)context.get("stats"));
        Long startTime = (Long)context.get("startTime");
        if (stats != null && startTime != null && stats.onFinally(System.nanoTime() - startTime)) {
            stats.setSlowTraceId(traceId);
        }
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    protected Class<CassandraStats> getValueType() {
        return CassandraStats.class;
    }

    protected String primaryKey() {
        return "node";
    }

    public String getName() {
        return "node";
    }
}

