/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.cassandra3.CassandraUtils;
import com.lubanops.apm.plugin.cassandra3.HostToClusterMapper;
import com.lubanops.apm.plugin.cassandra3.collector.CassandraCollector;
import java.util.Map;

public class ConnectionWriteInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            Object callback;
            if (CassandraCollector.INSTANCE.isEnable() && (callback = args[0]) instanceof TransformAccess) {
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"Cassandra");
                String host = CassandraUtils.getConnectionAddress(object);
                Map<String, Object> nodeContext = CassandraCollector.onNodeStartAsync(host);
                Map<String, Object> clusterContext = CassandraCollector.onClusterStartAsync(HostToClusterMapper.get(host));
                if (spanEvent != null) {
                    spanEvent.addTag("host", host);
                    TransformAccessUtils.saveToLopsAttributeMap((Object)callback, (String)"spanEvent", (Object)spanEvent);
                }
                TransformAccessUtils.saveToLopsAttributeMap((Object)callback, (String)"nodeContext", nodeContext);
                TransformAccessUtils.saveToLopsAttributeMap((Object)callback, (String)"clusterContext", clusterContext);
            }
        }
        catch (Exception executeException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)executeException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (CassandraCollector.INSTANCE.isEnable()) {
                Object callback;
                String errorTraceId = null;
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (spanEvent != null) {
                    errorTraceId = spanEvent.getTraceId();
                    TraceCollector.onError((Throwable)e);
                }
                if ((callback = args[0]) instanceof TransformAccess) {
                    Map nodeContext = (Map)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"nodeContext");
                    Map clusterContext = (Map)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"clusterContext");
                    CassandraCollector.onNodeErrorAsync(nodeContext, errorTraceId);
                    CassandraCollector.onClusterErrorAsync(clusterContext, errorTraceId);
                }
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception executeException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)executeException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (CassandraCollector.INSTANCE.isEnable()) {
                boolean isFailed = Boolean.TRUE.equals(this.hasErrorLocal.get());
                SpanEvent spanEvent = TraceCollector.onFinally((boolean)false);
                if (isFailed) {
                    Object callback = args[0];
                    if (callback instanceof TransformAccess) {
                        Map nodeContext = (Map)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"nodeContext");
                        Map clusterContext = (Map)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"clusterContext");
                        String traceId = spanEvent != null ? spanEvent.getTraceId() : null;
                        CassandraCollector.onNodeFinallyAsync(nodeContext, traceId);
                        CassandraCollector.onClusterFinallyAsync(clusterContext, traceId);
                    }
                    if (spanEvent != null) {
                        TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                    }
                    TransformAccessUtils.saveToLopsAttributeMap((Object)callback, (String)"isTraceFinished", (Object)Boolean.TRUE);
                }
                this.hasErrorLocal.remove();
            }
        }
        catch (Exception executeException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)executeException);
        }
    }
}

