/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.console.interceptor;

import com.huawei.console.common.http.client.BaseRequest;
import com.huawei.console.common.http.client.BaseResponse;
import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientType;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;

public class ConsoleClientInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof BaseRequest) {
                BaseRequest request = (BaseRequest)args[0];
                URI uri = request.getUri();
                String hostUri = uri.getScheme() + "://" + uri.getAuthority();
                String requestUri = hostUri + "/" + uri.getPath();
                String httpMethod = request.getMethod();
                HttpClientCollector.onStart((String)hostUri, (String)requestUri, (String)httpMethod, (String)HttpClientType.Nettyclient.name());
                HashMap<String, String> headers = request.getHttpHeader();
                if (headers == null) {
                    headers = new HashMap<String, String>();
                    request.setHttpHeader(headers);
                }
                headers.put(Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
                headers.put(Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
                headers.put(Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
                this.setHeaders(className, methodName, requestUri, httpMethod, headers);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
        return null;
    }

    private void setHeaders(String className, String methodName, String requestUri, String httpMethod, Map<String, String> headers) {
        List txName;
        String userFlag;
        String gTraceId;
        SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)HttpClientType.Nettyclient.name());
        if (spanEvent != null) {
            spanEvent.addTag("url", requestUri);
            spanEvent.addTag("httpMethod", httpMethod);
            String nextSpanId = spanEvent.generateNextSpanId();
            String traceId = spanEvent.getTraceId();
            headers.put(Headers.TRACE_ID.getValue(), traceId);
            headers.put(Headers.SPAN_ID.getValue(), nextSpanId);
            headers.put(Headers.SOURCE_EVENT_ID.getValue(), spanEvent.getEventId());
        }
        if (!StringUtils.isBlank((String)(gTraceId = TraceCollector.getVirtualTraceId()))) {
            headers.put(Headers.GTRACE_ID.getValue(), gTraceId);
        }
        if (!StringUtils.isBlank((String)(userFlag = TraceCollector.getUserFlag()))) {
            headers.put(Headers.USER_FLAG.getValue(), userFlag);
        }
        if ((txName = TransactionCollector.getTxName()) != null && txName.size() > 0) {
            headers.put(Headers.TXNANE_ID.getValue(), StringUtils.joinTxList((CharSequence)",", (List)txName));
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                HttpClientCollector.onThrowable((Throwable)e);
            }
        }
        catch (Exception exception) {
            LogFactory.getLogger().log(Level.SEVERE, "ConsoleClientInterceptor onError:", (Throwable)exception);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof BaseRequest) {
                BaseRequest request = (BaseRequest)args[0];
                String envId = null;
                if (result != null && result instanceof BaseResponse) {
                    BaseResponse response = (BaseResponse)result;
                    envId = this.getEnvId(response);
                    URI uri = request.getUri();
                    String hostUri = uri.getScheme() + "://" + uri.getAuthority();
                    String requestUri = hostUri + "/" + uri.getPath();
                    int code = response.getCode();
                    HttpClientCollector.onStatusCode((String)requestUri, (int)code);
                    TraceCollector.addTag((String)"code", (String)String.valueOf(code));
                }
                TraceCollector.onFinally();
                HttpClientCollector.onResponseClose(envId);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "ConsoleClientInterceptor onFinally:", (Throwable)e1);
        }
    }

    private String getEnvId(BaseResponse response) {
        Object headerObj;
        String envId = null;
        if (response instanceof AttributeAccess && (headerObj = ((AttributeAccess)response).getLopsFileds()[0]) != null) {
            Map headers;
            if ("org.springframework.http.HttpHeaders".equals(headerObj.getClass().getName())) {
                List valueList = ((HttpHeaders)headerObj).get((Object)Headers.ENV_ID.getValue());
                if (valueList != null && valueList.size() > 0) {
                    envId = (String)valueList.get(valueList.size() - 1);
                }
            } else if (headerObj instanceof Map && (headers = (Map)headerObj) != null) {
                envId = (String)headers.get(Headers.ENV_ID.getValue());
            }
        }
        return envId;
    }
}

