/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mysql.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlStatsAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.bootstrap.plugin.sql.collector.JdbcConnectionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlStats;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlStatsConfig;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class MysqlCollector
extends Collector {
    public static final MysqlCollector INSTANCE = new MysqlCollector();
    public static final SqlStatsConfig CONFIG = new SqlStatsConfig();
    public static final DefaultVersionAggregator INFO_AGGREGATOR = new DefaultVersionAggregator();
    public static final JdbcConnectionAggregator MYSQL_CONNECTION_AGGREGATOR = new JdbcConnectionAggregator();
    public static final MysqlStatsAggregator MYSQL_STATS_AGGREGATOR = new MysqlStatsAggregator();
    public static final SqlExceptionAggregator SQL_EXCEPTION_AGGREGATOR = new SqlExceptionAggregator();
    private final int[] ranges = new int[]{10, 100, 200, 1000, 10000};

    public static void setDriverVersion(String v) {
        INFO_AGGREGATOR.setVersion(v);
    }

    public static void onConnectionCreated(Integer connectionId) {
        if (connectionId != null && connectionId >= 0) {
            MYSQL_CONNECTION_AGGREGATOR.onConnectionCreated(connectionId);
        }
    }

    public static void onConnectionDestoyed(Integer connectionId) {
        if (connectionId != null && connectionId >= 0) {
            MYSQL_CONNECTION_AGGREGATOR.onConnectionDestoyed(connectionId);
        }
    }

    public static ConnectionStats onConnectionStart(Integer connectionId, String sql) {
        return MYSQL_CONNECTION_AGGREGATOR.onConnectionStart(connectionId);
    }

    public static void onConnectionException(Throwable t, String sql) {
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        MYSQL_CONNECTION_AGGREGATOR.onError(sql);
        SQL_EXCEPTION_AGGREGATOR.onThrowable(t, sql);
    }

    public static void onConnectionEnd(String sql, int updatedCount, int readRowCount) {
        if (updatedCount < 0) {
            updatedCount = 0;
        }
        if (readRowCount < 0) {
            readRowCount = 0;
        }
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        MYSQL_CONNECTION_AGGREGATOR.onFinally(sql, updatedCount, readRowCount, "Mysql");
    }

    public static SqlStats onStart(String sql) {
        if (!INSTANCE.isEnable() || StringUtils.isBlank((String)sql)) {
            return null;
        }
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        return MYSQL_STATS_AGGREGATOR.onStart(sql);
    }

    public static void onThrowable(Throwable th) {
        MYSQL_STATS_AGGREGATOR.onThrowable(th);
    }

    public static void onFinally(int updatedRowCount, int readRowCount) {
        MYSQL_STATS_AGGREGATOR.onFinally(updatedRowCount, readRowCount);
    }

    public void parseParameter(Map<String, String> parameters) {
        int[] range;
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        if ((range = (int[])ParameterParseUtil.getParameterValue(parameters, (String)"sqlRange", int[].class)) != null && range.length == 5) {
            MYSQL_STATS_AGGREGATOR.setRanges(range);
            MYSQL_CONNECTION_AGGREGATOR.setRanges(range);
        } else {
            MYSQL_STATS_AGGREGATOR.setRanges(this.ranges);
            MYSQL_CONNECTION_AGGREGATOR.setRanges(this.ranges);
        }
    }

    public String getCollectorName() {
        return "Mysql";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)INFO_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)MYSQL_CONNECTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)MYSQL_STATS_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)SQL_EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

