/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dbcp.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DbcpDataSourceAggregator
extends AbstractAggregator {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static final String DBCP_DATA_SOURCE_OBJECT_NAME = "org.apache.commons.dbcp2:name=*,type=BasicDataSource";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> res = new ArrayList<MonitorDataRow>();
        try {
            Set<ObjectName> dbcpDataSourceMBeans = this.server.queryNames(new ObjectName(DBCP_DATA_SOURCE_OBJECT_NAME), null);
            if (dbcpDataSourceMBeans == null || dbcpDataSourceMBeans.isEmpty()) {
                return res;
            }
            for (ObjectName dbcpDataSourceMBean : dbcpDataSourceMBeans) {
                MonitorDataRow row = new MonitorDataRow();
                row.put((Object)"url", this.server.getAttribute(dbcpDataSourceMBean, "Url"));
                row.put((Object)"driverClassName", this.server.getAttribute(dbcpDataSourceMBean, "DriverClassName"));
                row.put((Object)"initialSize", this.server.getAttribute(dbcpDataSourceMBean, "InitialSize"));
                row.put((Object)"minIdle", this.server.getAttribute(dbcpDataSourceMBean, "MinIdle"));
                row.put((Object)"maxIdle", this.server.getAttribute(dbcpDataSourceMBean, "MaxIdle"));
                row.put((Object)"maxTotal", this.server.getAttribute(dbcpDataSourceMBean, "MaxTotal"));
                row.put((Object)"numActive", this.server.getAttribute(dbcpDataSourceMBean, "NumActive"));
                row.put((Object)"numIdle", this.server.getAttribute(dbcpDataSourceMBean, "NumIdle"));
                row.put((Object)"maxWaitMillis", this.server.getAttribute(dbcpDataSourceMBean, "MaxWaitMillis"));
                row.put((Object)"testOnCreate", (Object)String.valueOf(this.server.getAttribute(dbcpDataSourceMBean, "TestOnCreate")));
                row.put((Object)"testOnBorrow", (Object)String.valueOf(this.server.getAttribute(dbcpDataSourceMBean, "TestOnBorrow")));
                row.put((Object)"testWhileIdle", (Object)String.valueOf(this.server.getAttribute(dbcpDataSourceMBean, "TestWhileIdle")));
                row.put((Object)"timeBetweenEvictionRunsMillis", this.server.getAttribute(dbcpDataSourceMBean, "TimeBetweenEvictionRunsMillis"));
                row.put((Object)"removeAbandonedOnBorrow", (Object)String.valueOf(this.server.getAttribute(dbcpDataSourceMBean, "RemoveAbandonedOnBorrow")));
                row.put((Object)"removeAbandonedOnMaintenance", (Object)String.valueOf(this.server.getAttribute(dbcpDataSourceMBean, "RemoveAbandonedOnMaintenance")));
                row.put((Object)"removeAbandonedTimeout", this.server.getAttribute(dbcpDataSourceMBean, "RemoveAbandonedTimeout"));
                res.add(row);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "DBCP harvest: \u91c7\u96c6\u76d1\u63a7\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return res;
    }

    public String getName() {
        return "dataSource";
    }
}

