/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.functiongraph.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.functiongraph.collector.FunctiongraphCollector;
import com.lubanops.apm.plugin.functiongraph.interceptor.ProcessInvokeInterceptor;
import java.lang.reflect.InvocationTargetException;

public class InitializeFunctionInterceptor
implements Interceptor {
    private static String functionName;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (FunctiongraphCollector.INSTANCE.isEnable()) {
            StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, null, null, null);
            startTraceRequest.setKind("Functiongraph");
            startTraceRequest.setSource(functionName + ".init");
            startTraceRequest.setRealSource(functionName + ".init");
            TraceCollector.onStart((StartTraceRequest)startTraceRequest);
            ProcessInvokeInterceptor.setInitTraceId(TraceCollector.getTraceId());
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (FunctiongraphCollector.INSTANCE.isEnable()) {
            if (e instanceof InvocationTargetException) {
                TraceCollector.onError((Throwable)((InvocationTargetException)e).getTargetException());
            } else {
                TraceCollector.onError((Throwable)e);
            }
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (FunctiongraphCollector.INSTANCE.isEnable()) {
            SpanEvent spanEvent = TraceCollector.onFinally((int)200);
            long timeUsed = spanEvent.getTimeUsed();
            ProcessInvokeInterceptor.setInitTime(timeUsed);
        }
    }

    public static String getFunctionName() {
        return functionName;
    }

    public static void setFunctionName(String functionName) {
        InitializeFunctionInterceptor.functionName = functionName;
    }
}

