/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.functiongraph.interceptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.huawei.function.runtime.context.FunctionInstance;
import com.huawei.function.runtime.rpc.generate.InvokeRequest;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.functiongraph.collector.FunctionGraphSampleFilter;
import com.lubanops.apm.plugin.functiongraph.collector.FunctiongraphCollector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ProcessInvokeInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();
    public static final long NANO_TO_MILLI = 1000000L;
    private static String initTraceId;
    private static String loadTime;
    private static long initTime;
    private static Long preloadTime;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (FunctiongraphCollector.INSTANCE.isEnable()) {
                Method method = FunctionInstance.getFunctionMethod();
                String functionMethodName = method.getDeclaringClass().getTypeName() + "." + method.getName();
                String traceId = null;
                String spanId = null;
                String domainId = null;
                String domainType = null;
                String sourceEventId = null;
                String gtraceId = null;
                String userFlag = null;
                String envId = null;
                String value = ((InvokeRequest)args[0]).getEvent().toStringUtf8();
                JsonObject event = new JsonParser().parse(value).getAsJsonObject();
                if (event != null) {
                    JsonObject eventJson = event.getAsJsonObject();
                    JsonObject headers = this.getHeaderJson(eventJson);
                    domainId = this.get(Headers.DOMAIN_ID.getValue(), eventJson, headers);
                    domainType = this.get(Headers.DOMAIN_TYPE.getValue(), eventJson, headers);
                    traceId = this.get(Headers.TRACE_ID.getValue(), eventJson, headers);
                    spanId = this.get(Headers.SPAN_ID.getValue(), eventJson, headers);
                    sourceEventId = this.get(Headers.SOURCE_EVENT_ID.getValue(), eventJson, headers);
                    envId = this.get(Headers.ENV_ID.getValue(), eventJson, headers);
                    gtraceId = this.get(Headers.GTRACE_ID.getValue(), eventJson, headers);
                    userFlag = this.get(Headers.USER_FLAG.getValue(), eventJson, headers);
                }
                if (!TraceCollector.isSameDomain(domainId, domainType)) {
                    envId = null;
                }
                FunctiongraphCollector.onStart(functionMethodName, envId);
                StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, traceId, spanId, gtraceId);
                startTraceRequest.setKind("Functiongraph");
                startTraceRequest.setSource(functionMethodName);
                startTraceRequest.setRealSource(functionMethodName);
                startTraceRequest.setSourceEventId(sourceEventId);
                startTraceRequest.setDomainId(domainId);
                startTraceRequest.setDomainType(domainType);
                this.onStartSpanEvent(startTraceRequest);
                TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "ProcessInvokeInterceptor onStart error", (Throwable)e);
        }
        return null;
    }

    private JsonObject getHeaderJson(JsonObject event) {
        JsonObject headers = null;
        try {
            JsonElement headersElement = event.get("headers");
            headers = headersElement != null ? headersElement.getAsJsonObject() : null;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "\u89e3\u6790header\u5f02\u5e38", (Throwable)e);
        }
        return headers;
    }

    private String get(String key, JsonObject event, JsonObject headers) {
        String value;
        JsonElement jsonElement = event.get(key);
        String string = value = jsonElement != null ? jsonElement.getAsString() : null;
        if (StringUtils.isBlank((String)value) && headers != null) {
            jsonElement = headers.get(key);
            value = jsonElement != null ? jsonElement.getAsString() : null;
        }
        return value;
    }

    private void onStartSpanEvent(StartTraceRequest startTraceRequest) {
        startTraceRequest.setSampleFilter((SampleFilter)new FunctionGraphSampleFilter());
        SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
        if (spanEvent != null) {
            long startTime = spanEvent.getStartTime();
            long startNanoTime = spanEvent.getStartNanoTime();
            String invokeMethod = spanEvent.getMethod();
            if (initTraceId != null) {
                TraceCollector.addTag((String)"initTraceId", (String)initTraceId);
                TraceCollector.addTag((String)"initTime", (String)(String.valueOf(initTime) + " ms"));
                startTime -= initTime;
                startNanoTime -= initTime * 1000000L;
                initTraceId = null;
                invokeMethod = "init | " + invokeMethod;
            }
            if (preloadTime != null) {
                TraceCollector.addTag((String)"preloadTime", (String)(preloadTime + " ms"));
                startTime -= preloadTime.longValue();
                startNanoTime -= preloadTime * 1000000L;
                preloadTime = null;
                invokeMethod = "preload | " + invokeMethod;
            }
            if (loadTime != null) {
                TraceCollector.addTag((String)"loadTime", (String)(loadTime + " ms"));
                long loadTimeUsed = Long.valueOf(loadTime);
                startTime -= loadTimeUsed;
                startNanoTime -= loadTimeUsed * 1000000L;
                loadTime = null;
                invokeMethod = "load | " + invokeMethod;
            }
            spanEvent.setStartNanoTime(startNanoTime);
            spanEvent.setStartTime(startTime);
            spanEvent.setMethod(invokeMethod);
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (FunctiongraphCollector.INSTANCE.isEnable()) {
            if (e instanceof InvocationTargetException) {
                TraceCollector.onError((Throwable)((InvocationTargetException)e).getTargetException());
            } else {
                TraceCollector.onError((Throwable)e);
            }
            FunctiongraphCollector.onError();
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (FunctiongraphCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally((int)200);
                FunctiongraphCollector.onFinally();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "ProcessInvokeInterceptor onFinally error", (Throwable)e);
        }
    }

    public static String getLoadTime() {
        return loadTime;
    }

    public static void setLoadTime(String loadTime) {
        ProcessInvokeInterceptor.loadTime = loadTime;
    }

    public static long getInitTime() {
        return initTime;
    }

    public static void setInitTime(long initTime) {
        ProcessInvokeInterceptor.initTime = initTime;
    }

    public static String getInitTraceId() {
        return initTraceId;
    }

    public static void setInitTraceId(String initTraceId) {
        ProcessInvokeInterceptor.initTraceId = initTraceId;
    }

    public static long getPreloadTime() {
        return preloadTime;
    }

    public static void setPreloadTime(long preloadTime) {
        ProcessInvokeInterceptor.preloadTime = preloadTime;
    }
}

