/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectReader6<T>
extends ObjectReaderAdapter<T> {
    protected final FieldReader fieldReader0;
    protected final FieldReader fieldReader1;
    protected final FieldReader fieldReader2;
    protected final FieldReader fieldReader3;
    protected final FieldReader fieldReader4;
    protected final FieldReader fieldReader5;
    final long hashCode0;
    final long hashCode1;
    final long hashCode2;
    final long hashCode3;
    final long hashCode4;
    final long hashCode5;
    final long hashCode0LCase;
    final long hashCode1LCase;
    final long hashCode2LCase;
    final long hashCode3LCase;
    final long hashCode4LCase;
    final long hashCode5LCase;
    protected ObjectReader objectReader0;
    protected ObjectReader objectReader1;
    protected ObjectReader objectReader2;
    protected ObjectReader objectReader3;
    protected ObjectReader objectReader4;
    protected ObjectReader objectReader5;

    ObjectReader6(Class objectClass, Supplier<T> creator, long features, JSONSchema schema, Function buildFunction, FieldReader fieldReader0, FieldReader fieldReader1, FieldReader fieldReader2, FieldReader fieldReader3, FieldReader fieldReader4, FieldReader fieldReader5) {
        this(objectClass, null, null, features, schema, creator, buildFunction, fieldReader0, fieldReader1, fieldReader2, fieldReader3, fieldReader4, fieldReader5);
    }

    public ObjectReader6(Class objectClass, String typeKey, String typeName, long features, JSONSchema schema, Supplier<T> creator, Function buildFunction, FieldReader ... fieldReaders) {
        super(objectClass, typeKey, typeName, features, schema, creator, buildFunction, fieldReaders);
        this.fieldReader0 = fieldReaders[0];
        this.fieldReader1 = fieldReaders[1];
        this.fieldReader2 = fieldReaders[2];
        this.fieldReader3 = fieldReaders[3];
        this.fieldReader4 = fieldReaders[4];
        this.fieldReader5 = fieldReaders[5];
        this.hashCode0 = this.fieldReader0.fieldNameHash;
        this.hashCode1 = this.fieldReader1.fieldNameHash;
        this.hashCode2 = this.fieldReader2.fieldNameHash;
        this.hashCode3 = this.fieldReader3.fieldNameHash;
        this.hashCode4 = this.fieldReader4.fieldNameHash;
        this.hashCode5 = this.fieldReader5.fieldNameHash;
        this.hashCode0LCase = this.fieldReader0.fieldNameHashLCase;
        this.hashCode1LCase = this.fieldReader1.fieldNameHashLCase;
        this.hashCode2LCase = this.fieldReader2.fieldNameHashLCase;
        this.hashCode3LCase = this.fieldReader3.fieldNameHashLCase;
        this.hashCode4LCase = this.fieldReader4.fieldNameHashLCase;
        this.hashCode5LCase = this.fieldReader5.fieldNameHashLCase;
        if (this.fieldReader0.isUnwrapped()) {
            this.extraFieldReader = this.fieldReader0;
        }
        if (this.fieldReader1.isUnwrapped()) {
            this.extraFieldReader = this.fieldReader1;
        }
        if (this.fieldReader2.isUnwrapped()) {
            this.extraFieldReader = this.fieldReader2;
        }
        if (this.fieldReader3.isUnwrapped()) {
            this.extraFieldReader = this.fieldReader3;
        }
        if (this.fieldReader4.isUnwrapped()) {
            this.extraFieldReader = this.fieldReader4;
        }
        if (this.fieldReader5.isUnwrapped()) {
            this.extraFieldReader = this.fieldReader5;
        }
        this.hasDefaultValue = this.fieldReader0.defaultValue != null || this.fieldReader1.defaultValue != null || this.fieldReader2.defaultValue != null || this.fieldReader3.defaultValue != null || this.fieldReader4.defaultValue != null || this.fieldReader5.defaultValue != null;
    }

    @Override
    protected void initDefaultValue(T object) {
        this.fieldReader0.acceptDefaultValue(object);
        this.fieldReader1.acceptDefaultValue(object);
        this.fieldReader2.acceptDefaultValue(object);
        this.fieldReader3.acceptDefaultValue(object);
        this.fieldReader4.acceptDefaultValue(object);
        this.fieldReader5.acceptDefaultValue(object);
    }

    @Override
    public T readArrayMappingJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        ObjectReader autoTypeReader;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if ((autoTypeReader = this.checkAutoType(jsonReader, this.objectClass, this.features | features)) != null && autoTypeReader != this && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        Object object = this.creator.get();
        int entryCnt = jsonReader.startArray();
        if (entryCnt > 0) {
            this.fieldReader0.readFieldValue(jsonReader, object);
            if (entryCnt > 1) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                if (entryCnt > 2) {
                    this.fieldReader2.readFieldValue(jsonReader, object);
                    if (entryCnt > 3) {
                        this.fieldReader3.readFieldValue(jsonReader, object);
                        if (entryCnt > 4) {
                            this.fieldReader4.readFieldValue(jsonReader, object);
                            if (entryCnt > 5) {
                                this.fieldReader5.readFieldValue(jsonReader, object);
                                for (int i = 6; i < entryCnt; ++i) {
                                    jsonReader.skipValue();
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Object object;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if (jsonReader.isArray()) {
            Object object2 = this.creator.get();
            int entryCnt = jsonReader.startArray();
            if (entryCnt > 0) {
                this.fieldReader0.readFieldValue(jsonReader, object2);
                if (entryCnt > 1) {
                    this.fieldReader1.readFieldValue(jsonReader, object2);
                    if (entryCnt > 2) {
                        this.fieldReader2.readFieldValue(jsonReader, object2);
                        if (entryCnt > 3) {
                            this.fieldReader3.readFieldValue(jsonReader, object2);
                            if (entryCnt > 4) {
                                this.fieldReader4.readFieldValue(jsonReader, object2);
                                if (entryCnt > 5) {
                                    this.fieldReader5.readFieldValue(jsonReader, object2);
                                    for (int i = 6; i < entryCnt; ++i) {
                                        jsonReader.skipValue();
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object2);
            }
            return object2;
        }
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (!jsonReader.nextIfMatch((byte)-90)) {
            throw new JSONException(jsonReader.info("expect object, but " + JSONB.typeName(jsonReader.getType())));
        }
        if (this.creator != null) {
            object = this.creator.get();
        } else if (JDKUtils.UNSAFE_SUPPORT && ((features | jsonReader.getContext().getFeatures()) & JSONReader.Feature.FieldBased.mask) != 0L) {
            try {
                object = UnsafeUtils.UNSAFE.allocateInstance(this.objectClass);
            }
            catch (InstantiationException e) {
                throw new JSONException(jsonReader.info("create instance error"), e);
            }
        } else {
            object = null;
        }
        if (object != null && this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        while (!jsonReader.nextIfMatch((byte)-91)) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode == 0L) continue;
            if (hashCode == this.hashCode0) {
                this.fieldReader0.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode1) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode2) {
                this.fieldReader2.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode3) {
                this.fieldReader3.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode4) {
                this.fieldReader4.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode5) {
                this.fieldReader5.readFieldValue(jsonReader, object);
                continue;
            }
            if (!jsonReader.isSupportSmartMatch(features | this.features)) {
                this.processExtra(jsonReader, object);
                continue;
            }
            long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
            if (nameHashCodeLCase == this.hashCode0LCase) {
                this.fieldReader0.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode1LCase) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode2LCase) {
                this.fieldReader2.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode3LCase) {
                this.fieldReader3.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode4LCase) {
                this.fieldReader4.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode5LCase) {
                this.fieldReader5.readFieldValue(jsonReader, object);
                continue;
            }
            this.processExtra(jsonReader, object);
        }
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfMatch(',');
            return null;
        }
        long featuresAll = jsonReader.features(this.features | features);
        if (jsonReader.isArray()) {
            if ((featuresAll & JSONReader.Feature.SupportArrayToBean.mask) != 0L) {
                jsonReader.nextIfMatch('[');
                Object object = this.creator.get();
                if (this.hasDefaultValue) {
                    this.initDefaultValue(object);
                }
                this.fieldReader0.readFieldValue(jsonReader, object);
                this.fieldReader1.readFieldValue(jsonReader, object);
                this.fieldReader2.readFieldValue(jsonReader, object);
                this.fieldReader3.readFieldValue(jsonReader, object);
                this.fieldReader4.readFieldValue(jsonReader, object);
                this.fieldReader5.readFieldValue(jsonReader, object);
                if (!jsonReader.nextIfMatch(']')) {
                    throw new JSONException(jsonReader.info("array to bean end error"));
                }
                jsonReader.nextIfMatch(',');
                if (this.buildFunction != null) {
                    return (T)this.buildFunction.apply(object);
                }
                return object;
            }
            return this.processObjectInputSingleItemArray(jsonReader, fieldType, fieldName, featuresAll);
        }
        jsonReader.nextIfMatch('{');
        Object object = this.creator.get();
        if (this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        int i = 0;
        while (!jsonReader.nextIfMatch('}')) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (i == 0 && hashCode == HASH_TYPE) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                if ((autoTypeObjectReader != null || (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) != null) && autoTypeObjectReader != this) {
                    object = autoTypeObjectReader.readObject(jsonReader, fieldType, fieldName, features);
                    break;
                }
            } else if (hashCode == this.hashCode0) {
                this.fieldReader0.readFieldValue(jsonReader, object);
            } else if (hashCode == this.hashCode1) {
                this.fieldReader1.readFieldValue(jsonReader, object);
            } else if (hashCode == this.hashCode2) {
                this.fieldReader2.readFieldValue(jsonReader, object);
            } else if (hashCode == this.hashCode3) {
                this.fieldReader3.readFieldValue(jsonReader, object);
            } else if (hashCode == this.hashCode4) {
                this.fieldReader4.readFieldValue(jsonReader, object);
            } else if (hashCode == this.hashCode5) {
                this.fieldReader5.readFieldValue(jsonReader, object);
            } else if (!jsonReader.isSupportSmartMatch(features | this.features)) {
                this.processExtra(jsonReader, object);
            } else {
                long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                if (nameHashCodeLCase == this.hashCode0LCase) {
                    this.fieldReader0.readFieldValue(jsonReader, object);
                } else if (nameHashCodeLCase == this.hashCode1LCase) {
                    this.fieldReader1.readFieldValue(jsonReader, object);
                } else if (nameHashCodeLCase == this.hashCode2LCase) {
                    this.fieldReader2.readFieldValue(jsonReader, object);
                } else if (nameHashCodeLCase == this.hashCode3LCase) {
                    this.fieldReader3.readFieldValue(jsonReader, object);
                } else if (nameHashCodeLCase == this.hashCode4LCase) {
                    this.fieldReader4.readFieldValue(jsonReader, object);
                } else if (nameHashCodeLCase == this.hashCode5LCase) {
                    this.fieldReader5.readFieldValue(jsonReader, object);
                } else {
                    this.processExtra(jsonReader, object);
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        if (hashCode == this.hashCode0) {
            return this.fieldReader0;
        }
        if (hashCode == this.hashCode1) {
            return this.fieldReader1;
        }
        if (hashCode == this.hashCode2) {
            return this.fieldReader2;
        }
        if (hashCode == this.hashCode3) {
            return this.fieldReader3;
        }
        if (hashCode == this.hashCode4) {
            return this.fieldReader4;
        }
        if (hashCode == this.hashCode5) {
            return this.fieldReader5;
        }
        return null;
    }

    @Override
    public FieldReader getFieldReaderLCase(long hashCode) {
        if (hashCode == this.hashCode0LCase) {
            return this.fieldReader0;
        }
        if (hashCode == this.hashCode1LCase) {
            return this.fieldReader1;
        }
        if (hashCode == this.hashCode2LCase) {
            return this.fieldReader2;
        }
        if (hashCode == this.hashCode3LCase) {
            return this.fieldReader3;
        }
        if (hashCode == this.hashCode4LCase) {
            return this.fieldReader4;
        }
        if (hashCode == this.hashCode5LCase) {
            return this.fieldReader5;
        }
        return null;
    }
}

