/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.premain.utils;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

public class LibPathUtils {
    private static final String AGENT_JAR_FILE_NAME = "apm-javaagent.jar";
    private static String agentPath = "";

    public static List<URL> getLibUrl() {
        ArrayList<URL> libURLList = new ArrayList<URL>();
        try {
            ProtectionDomain pd = LibPathUtils.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            String jarPath = cs.getLocation().getPath();
            String agentPath = jarPath.substring(0, jarPath.lastIndexOf(AGENT_JAR_FILE_NAME));
            String libPath = agentPath + File.separator + "lib";
            libURLList.addAll(FileUtils.getLibUrl((String)libPath));
            String corePath = agentPath + File.separator + "core";
            libURLList.addAll(LibPathUtils.getTransformerLibUrl(corePath));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return libURLList;
    }

    public static String getAgentPath() {
        String agentPath = LibPathUtils.agentPath;
        if (null != agentPath && agentPath.length() > 0) {
            return agentPath;
        }
        try {
            ProtectionDomain pd = LibPathUtils.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            String jarPath = cs.getLocation().getPath();
            LibPathUtils.agentPath = agentPath = jarPath.substring(0, jarPath.lastIndexOf(AGENT_JAR_FILE_NAME));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return agentPath;
    }

    public static List<URL> getTransformerLibUrl(String path) {
        ArrayList<URL> jarURLList = new ArrayList<URL>();
        try {
            File libDir = new File(path);
            File[] files = libDir.listFiles();
            if (files != null) {
                File transformerFile = null;
                for (File file : files) {
                    if ((transformerFile = transformerFile == null || !transformerFile.getName().substring(0, transformerFile.getName().lastIndexOf("-")).equals(file.getName().substring(0, file.getName().lastIndexOf("-"))) ? file : LibPathUtils.compareFileName(file, transformerFile)) == null) continue;
                    LogFactory.getLogger().log(Level.INFO, String.format("[CLASS LOAD]jar[%s] loaded.", transformerFile.toURI().toURL()));
                    jarURLList.add(transformerFile.toURI().toURL());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jarURLList;
    }

    private static File compareFileName(File file, File transformerFile) {
        String fileName = file.getName();
        String transformerFileName = transformerFile.getName();
        String javaagentVersion = fileName.substring(fileName.lastIndexOf("-") + 1, fileName.lastIndexOf(".jar"));
        String newJavaagentVersion = transformerFileName.substring(fileName.lastIndexOf("-") + 1, transformerFileName.lastIndexOf(".jar"));
        String[] versionArray1 = javaagentVersion.split("\\.");
        String[] versionArray2 = newJavaagentVersion.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        int n = diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        if (diff > 0) {
            return file;
        }
        return transformerFile;
    }

    public static List<JarFile> getPluginJar() {
        ArrayList<JarFile> list = new ArrayList<JarFile>();
        try {
            String bootPath = LibPathUtils.getAgentPath() + "plugins";
            LibPathUtils.getFiles(list, bootPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private static void getFiles(List<JarFile> list, String bootPath) throws IOException {
        File libDir = new File(bootPath);
        File[] files = libDir.listFiles();
        if (files != null) {
            for (File file : files) {
                list.add(new JarFile(file));
            }
        }
    }

    public static List<JarFile> getBootstrapJar() {
        ArrayList<JarFile> list = new ArrayList<JarFile>();
        try {
            String bootPath = LibPathUtils.getAgentPath() + File.separator + "boot";
            LibPathUtils.getFiles(list, bootPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static List<JarFile> getPluginJars() {
        ArrayList<JarFile> list = new ArrayList<JarFile>();
        try {
            String bootPath = LibPathUtils.getAgentPath() + File.separator + "plugins";
            LibPathUtils.getFiles(list, bootPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static List<File> getPluginFiles() {
        ArrayList<File> list = new ArrayList<File>();
        try {
            String bootPath = LibPathUtils.getAgentPath() + File.separator + "plugins";
            File libDir = new File(bootPath);
            File[] files = libDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    list.add(file);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static String getBootstrapJarPath() {
        return LibPathUtils.getAgentPath() + File.separator + "boot";
    }

    public static String getPluginsJarPath() {
        return LibPathUtils.getAgentPath() + File.separator + "plugins";
    }

    public static File getSystemJarFile() {
        try {
            File[] fileArray;
            int n;
            int n2;
            String bootPath = LibPathUtils.getAgentPath() + File.separator + "system";
            File libDir = new File(bootPath);
            File[] files = libDir.listFiles();
            if (files != null && (n2 = 0) < (n = (fileArray = files).length)) {
                File file = fileArray[n2];
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

