/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.common.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.trace.ErrorType;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.exception.common.collector.ExceptionStatsAggregator;
import com.lubanops.apm.plugin.exception.common.collector.LogVersionAggregator;
import com.lubanops.apm.plugin.exception.common.stats.ExceptionConfig;
import java.util.Map;

public class ExceptionCollector
extends Collector {
    public static final ExceptionStatsAggregator EXCEPTION_STATS_AGGREGATOR = new ExceptionStatsAggregator();
    public static final LogVersionAggregator LOG_VERSION_AGGREGATOR = new LogVersionAggregator();
    public static final String COLLECTOR_NAME = "Exception";
    public static final ExceptionCollector INSTANCE = new ExceptionCollector();
    private static ThreadLocal<Boolean> context = new ThreadLocal();

    public static boolean hasContext() {
        Boolean bl = context.get();
        return bl != null;
    }

    public static void onError(String longName, String logType, Object m, Throwable th) {
        TraceCollector.setException((Boolean)true);
        if (!INSTANCE.isEnable()) {
            return;
        }
        Boolean bl = context.get();
        if (bl != null) {
            return;
        }
        String exceptionType = th == null ? "NONE" : th.getClass().getName();
        if (AgentConfigManager.isFilterLogMessage()) {
            m = ExceptionCollector.filterMsg(m);
        }
        ExceptionCollector.addTraceInfo(exceptionType, longName, logType, m, th);
        EXCEPTION_STATS_AGGREGATOR.onError(exceptionType, longName, logType, m, th);
        context.set(Boolean.TRUE);
    }

    private static Object filterMsg(Object m) {
        return "****";
    }

    private static void addTraceInfo(String exceptionType, String logName, String logType, Object m, Throwable th) {
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        if (spanEvent != null) {
            if (ExceptionConfig.isLogError()) {
                spanEvent.setSpanError(true);
            } else {
                spanEvent.setHasError(true);
            }
            spanEvent.setErrorReasons(ErrorType.LOG_ERR.name());
            spanEvent.addTag("exceptionType", exceptionType);
            if (th != null) {
                spanEvent.addTag("exceptionMsg", String.valueOf(m) + "," + String.valueOf(th.getMessage()));
            } else {
                spanEvent.addTag("exceptionMsg", String.valueOf(m));
            }
        }
    }

    public static void onError(String logName, String logtype, Object m) {
        ExceptionCollector.onError(logName, logtype, m, null);
    }

    public static void clearContext() {
        context.remove();
    }

    public static void setLog4jVersion(String v) {
        LOG_VERSION_AGGREGATOR.setLog4jVersion(v);
    }

    public static void setLog4j2Version(String v) {
        LOG_VERSION_AGGREGATOR.setLog4j2Version(v);
    }

    public static void setCommonLogVersion(String v) {
        LOG_VERSION_AGGREGATOR.setCommonLogVersion(v);
    }

    public static void setLogBackVersion(String v) {
        LOG_VERSION_AGGREGATOR.setLogBackVersion(v);
    }

    public static void setSlf4jApiVersion(String v) {
        LOG_VERSION_AGGREGATOR.setSlf4jApiVersion(v);
    }

    public static void setSlf4j_jdk(String v) {
        LOG_VERSION_AGGREGATOR.setSlf4jJdk(v);
    }

    public static void setSlf4j_jcl(String v) {
        LOG_VERSION_AGGREGATOR.setSlf4jJcl(v);
    }

    public static void setSlf4j_simple(String v) {
        LOG_VERSION_AGGREGATOR.setSlf4jSimple(v);
    }

    public static void setSlf4j_log4j(String v) {
        LOG_VERSION_AGGREGATOR.setSlf4jLog4j(v);
    }

    public String getCollectorName() {
        return COLLECTOR_NAME;
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public static ExceptionCollector getInstance() {
        return INSTANCE;
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_STATS_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)LOG_VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

